/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import java.util.ArrayList;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerBipedRotationCustomTCArmor
extends Transformer {
    private static final String CLASS = "thaumcraft.client.renderers.models.gear.ModelCustomArmor";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isAllowedToFail() {
        return true;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            String rotationAngles = TransformUtil.remapMethodName("thaumcraft/client/renderers/models/gear/ModelCustomArmor", "func_78087_a", Type.VOID_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.getType((String)"Lnet/minecraft/entity/Entity;"));
            MethodNode rot = TransformUtil.findMethod(classNode, rotationAngles, "(FFFFFFLnet/minecraft/entity/Entity;)V");
            if (rot.instructions.size() != 1009 || rot.localVariables.size() != 15) {
                throw new TransformerException("setRotationAngles function is not the expected size, this transformer will almost certainly break it");
            }
            int ret = TransformUtil.findLineNumber(rot, 38);
            if (ret == -1) {
                throw new TransformerException("Could not locate required instructions");
            }
            AbstractInsnNode insertAfter = rot.instructions.get(ret).getNext();
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/client/model/ModelBiped", rotationAngles, "(FFFFFFLnet/minecraft/entity/Entity;)V", false));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 7));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(23, 6));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(23, 5));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(23, 4));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(23, 3));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(23, 2));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(23, 1));
            rot.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 0));
            ret += 11;
            int end = TransformUtil.findLineNumber(rot, 206);
            if (end == -1) {
                throw new TransformerException("Could not locate required instructions");
            }
            for (int i = 0; i < end - ret - 1; ++i) {
                rot.instructions.remove(rot.instructions.get(ret));
            }
            ArrayList<LocalVariableNode> toRemove = new ArrayList<LocalVariableNode>();
            for (LocalVariableNode local : rot.localVariables) {
                if (local == null || local.index <= 7) continue;
                toRemove.add(local);
            }
            rot.localVariables.removeAll(toRemove);
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

