/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thecodex6824.thaumicaugmentation.api.ThaumicAugmentationAPI;

@IFMLLoadingPlugin.Name(value="Thaumic Augmentation Core Plugin")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=1005)
@IFMLLoadingPlugin.TransformerExclusions(value={"thecodex6824.thaumicaugmentation.core"})
public class ThaumicAugmentationCore
implements IFMLLoadingPlugin {
    private static Logger log = LogManager.getLogger((String)"thaumicaugmentationcore");
    private static Configuration config;
    private static boolean enabled;
    private static ImmutableSet<String> excludedTransformers;

    public ThaumicAugmentationCore() {
        if (config != null) {
            throw new RuntimeException("Coremod loading twice (?)");
        }
        config = new Configuration(new File("config", "thaumicaugmentation.cfg"));
        enabled = !config.getBoolean("DisableCoremod", "general", false, "");
        excludedTransformers = ImmutableSet.copyOf((Object[])config.getStringList("DisabledTransformers", "general", new String[0], ""));
    }

    public static Logger getLogger() {
        return log;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static Set<String> getExcludedTransformers() {
        return excludedTransformers;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"thecodex6824.thaumicaugmentation.core.TATransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        if (enabled) {
            ThaumicAugmentationAPI.setCoremodAvailable();
        } else {
            log.info("Thaumic Augmentation coremod disabled by config request");
        }
    }
}

