/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.util.maze;

import net.minecraft.util.EnumFacing;
import thecodex6824.thaumicaugmentation.common.util.maze.MazeCell;

public class Maze {
    protected int width;
    protected int length;
    protected MazeCell[] cells;

    public Maze(int mazeWidth, int mazeLength, MazeCell[] mazeCells) {
        this.width = mazeWidth;
        this.length = mazeLength;
        this.cells = mazeCells;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public MazeCell getCell(int x, int z) {
        return this.cells[z * this.width + x];
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int z = 0; z < this.length; ++z) {
            for (int x = 0; x < this.width; ++x) {
                MazeCell cell = this.cells[z * this.width + x];
                if (cell.getNumWalls() == 4) {
                    result.append(' ');
                    continue;
                }
                if (cell.getNumWalls() == 3) {
                    EnumFacing open = null;
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (cell.hasWall(dir)) continue;
                        open = dir;
                        break;
                    }
                    if (open == EnumFacing.NORTH) {
                        result.append('\u2575');
                        continue;
                    }
                    if (open == EnumFacing.EAST) {
                        result.append('\u2576');
                        continue;
                    }
                    if (open == EnumFacing.SOUTH) {
                        result.append('\u2577');
                        continue;
                    }
                    result.append('\u2574');
                    continue;
                }
                if (cell.getNumWalls() == 2) {
                    int angle2;
                    EnumFacing open1 = null;
                    EnumFacing open2 = null;
                    EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
                    int n = enumFacingArray.length;
                    for (int dir = 0; dir < n; ++dir) {
                        EnumFacing dir2 = enumFacingArray[dir];
                        if (cell.hasWall(dir2)) continue;
                        if (open1 == null) {
                            open1 = dir2;
                            continue;
                        }
                        open2 = dir2;
                        break;
                    }
                    if (open1.func_176734_d() == open2) {
                        if (open1.func_176740_k() == EnumFacing.Axis.X) {
                            result.append('\u2500');
                            continue;
                        }
                        result.append('\u2502');
                        continue;
                    }
                    int angle1 = (int)open1.func_185119_l();
                    int temp = Math.min(angle1, angle2 = (int)open2.func_185119_l());
                    if (temp == angle2) {
                        angle2 = angle1;
                        angle1 = temp;
                    }
                    if (angle1 == 0 && angle2 == 90) {
                        result.append('\u2510');
                        continue;
                    }
                    if (angle1 == 90 && angle2 == 180) {
                        result.append('\u2518');
                        continue;
                    }
                    if (angle1 == 180 && angle2 == 270) {
                        result.append('\u2514');
                        continue;
                    }
                    result.append('\u250c');
                    continue;
                }
                if (cell.getNumWalls() == 1) {
                    EnumFacing closed = null;
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (!cell.hasWall(dir)) continue;
                        closed = dir;
                        break;
                    }
                    if (closed == EnumFacing.NORTH) {
                        result.append('\u252c');
                        continue;
                    }
                    if (closed == EnumFacing.EAST) {
                        result.append('\u2524');
                        continue;
                    }
                    if (closed == EnumFacing.SOUTH) {
                        result.append('\u2534');
                        continue;
                    }
                    result.append('\u251c');
                    continue;
                }
                result.append('\u253c');
            }
            if (z >= this.length - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }
}

