/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class WeightedRandom<T extends Comparable<T>> {
    private ImmutableList<T> choice;
    private int[] weight;

    protected WeightedRandom(List<T> choices, int[] calculatedWeights) {
        this.choice = new ImmutableList.Builder().addAll(choices).build();
        this.weight = calculatedWeights;
    }

    public WeightedRandom(Map<T, Integer> pairs) {
        this.choice = ImmutableList.copyOf(pairs.keySet());
        this.weight = new int[pairs.size()];
        ArrayList<Integer> tempWeights = new ArrayList<Integer>(pairs.values());
        for (int i = 0; i < pairs.size(); ++i) {
            this.weight[i] = i > 0 ? this.weight[i - 1] + tempWeights.get(i) : tempWeights.get(i);
        }
    }

    public WeightedRandom(List<T> choices, List<Integer> weights) {
        if (choices.size() != weights.size()) {
            throw new IllegalArgumentException("Different amount of choices and weights");
        }
        this.choice = ImmutableList.copyOf(choices);
        this.weight = new int[weights.size()];
        for (int i = 0; i < weights.size(); ++i) {
            this.weight[i] = i > 0 ? this.weight[i - 1] + weights.get(i) : weights.get(i);
        }
    }

    public WeightedRandom(WeightedRandom<T> toCopy) {
        this.choice = ImmutableList.copyOf(toCopy.choice);
        this.weight = Arrays.copyOf(toCopy.weight, toCopy.weight.length);
    }

    private int binarySearch(int n) {
        int left = 0;
        int right = this.weight.length - 1;
        while (left < right) {
            int check = left + (right - left) / 2;
            if (this.weight[check] <= n && this.weight[check + 1] > n) {
                return check + 1;
            }
            if (this.weight[check] <= n) {
                left = check + 1;
                continue;
            }
            if (this.weight[check] <= n) continue;
            right = check;
        }
        if (this.weight[0] > n) {
            return 0;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.choice.isEmpty();
    }

    public boolean hasChoice(T c) {
        return this.choice.contains(c);
    }

    public T get(Random rand) {
        if (this.weight.length == 0) {
            return null;
        }
        return (T)((Comparable)this.choice.get(this.binarySearch(rand.nextInt(this.weight[this.weight.length - 1]))));
    }

    private int linearSearch(List<T> toSearch, T toFind) {
        for (int i = 0; i < toSearch.size(); ++i) {
            if (!((Comparable)toSearch.get(i)).equals(toFind)) continue;
            return i;
        }
        return -1;
    }

    public WeightedRandom<T> removeChoice(T element) {
        ArrayList<T> newList = new ArrayList<T>(this.choice);
        ArrayList<Integer> weightList = new ArrayList<Integer>(Arrays.asList(ArrayUtils.toObject((int[])this.weight)));
        int toRemoveIndex = this.linearSearch(newList, element);
        newList.remove(toRemoveIndex);
        int value = toRemoveIndex > 0 ? weightList.remove(toRemoveIndex) - weightList.get(toRemoveIndex - 1) : weightList.remove(toRemoveIndex);
        for (int i = toRemoveIndex; i < weightList.size(); ++i) {
            weightList.set(i, weightList.get(i) - value);
        }
        return new WeightedRandom<T>(newList, ArrayUtils.toPrimitive((Integer[])weightList.toArray(new Integer[weightList.size()])));
    }

    public WeightedRandom<T> removeChoice(Collection<T> toRemove) {
        ArrayList<T> newList = new ArrayList<T>(this.choice);
        ArrayList<Integer> weightList = new ArrayList<Integer>(Arrays.asList(ArrayUtils.toObject((int[])this.weight)));
        for (Comparable element : toRemove) {
            int toRemoveIndex = this.linearSearch(newList, element);
            newList.remove(toRemoveIndex);
            int value = toRemoveIndex > 0 ? weightList.remove(toRemoveIndex) - weightList.get(toRemoveIndex - 1) : weightList.remove(toRemoveIndex);
            for (int i = toRemoveIndex; i < weightList.size(); ++i) {
                weightList.set(i, weightList.get(i) - value);
            }
        }
        return new WeightedRandom<T>(newList, ArrayUtils.toPrimitive((Integer[])weightList.toArray(new Integer[weightList.size()])));
    }
}

