/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class MorphicArmorHelper {
    private static final List<ItemStack> EMPTY_ARMOR = ImmutableList.of((Object)ItemStack.field_190927_a, (Object)ItemStack.field_190927_a, (Object)ItemStack.field_190927_a, (Object)ItemStack.field_190927_a);
    public static final String MORPHIC_ARMOR_KEY = "ta_morphic_armor";

    private MorphicArmorHelper() {
    }

    public static List<ItemStack> getArmorInventory(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).field_71071_by.field_70460_b;
        }
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).field_184657_bw;
        }
        return EMPTY_ARMOR;
    }

    public static boolean hasMorphicArmor(ItemStack stack) {
        return stack.func_179543_a(MORPHIC_ARMOR_KEY) != null;
    }

    public static ItemStack getMorphicArmor(ItemStack stack) {
        NBTTagCompound item = stack.func_179543_a(MORPHIC_ARMOR_KEY);
        return item != null ? new ItemStack(item) : ItemStack.field_190927_a;
    }

    public static void setMorphicArmor(ItemStack stack, ItemStack display) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (display.func_190926_b()) {
            stack.func_77978_p().func_82580_o(MORPHIC_ARMOR_KEY);
        } else {
            stack.func_77978_p().func_74782_a(MORPHIC_ARMOR_KEY, (NBTBase)display.serializeNBT());
        }
    }
}

