/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item.foci;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.common.entity.EntityFocusShield;

public class FocusEffectVoidShield
extends FocusEffect {
    public Aspect getAspect() {
        return Aspect.MAGIC;
    }

    public int getComplexity() {
        return (int)((double)this.getSettingValue("health") / 1.5) - 2 + this.getSettingValue("reflect") * 15;
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("health", "focus.thaumicaugmentation.shield.health", (NodeSetting.INodeSettingType)new NodeSettingShieldHealth(), "FIRSTSTEPS"), new NodeSettingReflectProjectiles()};
    }

    public String getKey() {
        return "focus.thaumicaugmentation.shield";
    }

    public String getResearch() {
        return "FOCUS_SHIELD";
    }

    public boolean execute(RayTraceResult result, @Nullable Trajectory trajectory, float finalPower, int whatever) {
        World world = this.getPackage().world;
        EntityLivingBase caster = this.getPackage().getCaster();
        if (caster != null) {
            IImpetusStorage storage = null;
            for (EnumHand hand : EnumHand.values()) {
                IAugmentableItem item;
                ItemStack active = caster.func_184586_b(hand);
                IImpetusStorage temp = (IImpetusStorage)active.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                if (temp == null && (item = (IAugmentableItem)active.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                    for (ItemStack stack : item.getAllAugments()) {
                        IImpetusStorage test = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                        if (test == null || !test.canExtract() || test.getEnergyStored() < TAConfig.shieldFocusImpetusCost.getValue()) continue;
                        temp = test;
                        break;
                    }
                }
                if (temp == null) continue;
                storage = temp;
                break;
            }
            if (storage == null) {
                storage = (IImpetusStorage)caster.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
            }
            if (storage != null && !world.field_72995_K && result.field_72313_a == RayTraceResult.Type.ENTITY) {
                EntityFocusShield shield = null;
                if (result.field_72308_g instanceof EntityFocusShield) {
                    shield = (EntityFocusShield)result.field_72308_g;
                } else {
                    List shields = world.func_175647_a(EntityFocusShield.class, result.field_72308_g.func_174813_aQ().func_186662_g(1.5), e -> e != null && result.field_72308_g.equals((Object)e.func_70902_q()));
                    if (!shields.isEmpty()) {
                        shield = (EntityFocusShield)shields.get(0);
                    }
                }
                if (shield != null) {
                    if (!caster.func_70093_af() && storage != null) {
                        double prop = Math.max((double)(shield.func_110143_aJ() / shield.func_110138_aP()), (double)shield.getTimeAlive() / (double)shield.getTotalLifespan());
                        if (ImpetusAPI.tryExtractFully(storage, (long)(prop * (double)TAConfig.shieldFocusImpetusCost.getValue().longValue()), (Entity)caster)) {
                            shield.func_70606_j(shield.func_110138_aP());
                            shield.resetTimeAlive();
                            caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 0.2f, 1.2f);
                            return true;
                        }
                        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundsTC.jacobs, SoundCategory.PLAYERS, 0.2f, 0.6f);
                        return false;
                    }
                    if (caster.func_70093_af() && caster.func_110124_au().equals(shield.getCasterID()) || caster.func_110124_au().equals(shield.func_184753_b())) {
                        shield.func_70106_y();
                        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 0.2f, 0.75f);
                        return true;
                    }
                } else if (storage != null && ImpetusAPI.tryExtractFully(storage, TAConfig.shieldFocusImpetusCost.getValue(), (Entity)caster)) {
                    shield = new EntityFocusShield(world);
                    shield.setOwner(result.field_72308_g);
                    shield.setCasterID(caster.func_110124_au());
                    shield.setMaxHealth(this.getSettingValue("health"));
                    shield.func_70606_j(shield.func_110138_aP());
                    shield.setReflect(this.getSettingValue("reflect") != 0);
                    caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 0.2f, 1.2f);
                    return world.func_72838_d((Entity)shield);
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        fb.func_187114_a(40 + world.field_73012_v.nextInt(40));
        fb.setParticles(16, 1, 1);
        fb.setSlowDown(0.5);
        fb.setAlphaF(new float[]{1.0f, 0.0f});
        fb.setScale(new float[]{(float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f)});
        int color = 5243080;
        fb.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        fb.setRotationSpeed(world.field_73012_v.nextFloat(), 0.0f);
        ParticleEngine.addEffectWithDelay((World)world, (Particle)fb, (int)0);
    }

    protected class NodeSettingReflectProjectiles
    extends NodeSetting {
        public NodeSettingReflectProjectiles() {
            super("reflect", "focus.thaumicaugmentation.shield.reflect", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntList(new int[]{0, 1}, new String[]{"focus.thaumicaugmentation.shield.reflect_no", "focus.thaumicaugmentation.shield.reflect_yes"}), "FIRSTSTEPS");
        }
    }

    protected class NodeSettingShieldHealth
    extends NodeSetting.NodeSettingIntRange {
        public NodeSettingShieldHealth() {
            super(5, 75);
        }

        public int getDefault() {
            return 5;
        }
    }
}

