/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item.foci;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.block.property.ILightSourceBlock;

public class FocusEffectLight
extends FocusEffect {
    public Aspect getAspect() {
        return Aspect.LIGHT;
    }

    public int getComplexity() {
        return this.getSettingValue("intensity");
    }

    public String getKey() {
        return "focus.thaumicaugmentation.light";
    }

    public String getResearch() {
        return "FOCUS_LIGHT";
    }

    public boolean execute(RayTraceResult result, @Nullable Trajectory trajectory, float finalPower, int something) {
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = this.getPackage().world.func_180495_p(result.func_178782_a());
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.getPackage().world, result.func_178782_a()) || state.func_177230_c().func_176200_f((IBlockAccess)this.getPackage().world, result.func_178782_a())) {
                return this.placeLightSource(result.func_178782_a(), result.field_178784_b, this.getSettingValue("intensity"));
            }
            BlockPos pos = result.func_178782_a().func_177972_a(result.field_178784_b);
            state = this.getPackage().world.func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.getPackage().world, pos) || state.func_177230_c().func_176200_f((IBlockAccess)this.getPackage().world, pos)) {
                return this.placeLightSource(pos, result.field_178784_b, this.getSettingValue("intensity"));
            }
        } else {
            if (result.field_72313_a == RayTraceResult.Type.MISS) {
                return this.placeLightSource(result.func_178782_a(), result.field_178784_b, this.getSettingValue("intensity"));
            }
            if (result.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)result.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_188423_x, this.getSettingValue("intensity") * 10, 0, true, false));
                return true;
            }
        }
        return false;
    }

    protected boolean placeLightSource(BlockPos pos, EnumFacing side, int intensity) {
        World world = this.getPackage().world;
        if (world.func_175707_a(pos, pos) && world.func_180495_p(pos).func_177230_c() != TABlocks.TEMPORARY_LIGHT && world.func_190527_a(TABlocks.TEMPORARY_LIGHT, pos, true, side, (Entity)this.getPackage().getCaster())) {
            return world.func_175656_a(pos, TABlocks.TEMPORARY_LIGHT.func_176223_P().func_177226_a((IProperty)ILightSourceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(intensity)));
        }
        return false;
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("intensity", "focus.thaumicaugmentation.light.intensity", (NodeSetting.INodeSettingType)new NodeSettingLightIntensity())};
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.2f, 1.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        fb.func_187114_a(40 + world.field_73012_v.nextInt(40));
        fb.setParticles(16, 1, 1);
        fb.setSlowDown(0.5);
        fb.setAlphaF(new float[]{1.0f, 0.0f});
        fb.setScale(new float[]{(float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f)});
        int color = this.getAspect().getColor();
        fb.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        fb.setRotationSpeed(world.field_73012_v.nextFloat(), 0.0f);
        ParticleEngine.addEffectWithDelay((World)world, (Particle)fb, (int)0);
    }

    protected class NodeSettingLightIntensity
    extends NodeSetting.NodeSettingIntRange {
        public NodeSettingLightIntensity() {
            super(1, 15);
        }

        public int getDefault() {
            return 8;
        }
    }
}

