/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;

public class EntityAIAttackRangedCustomMutex<T extends EntityLiving>
extends EntityAIBase {
    protected T entity;
    protected EntityLivingBase target;
    protected int rangedAttackTime;
    protected int seeTime;
    protected int attackIntervalMin;
    protected int maxRangedAttackTime;
    protected float attackRadius;
    protected float maxAttackDistance;

    public EntityAIAttackRangedCustomMutex(T attacker, int maxAttackTime, float maxAttackDistanceIn, int mutex) {
        this(attacker, maxAttackTime, maxAttackTime, maxAttackDistanceIn, mutex);
    }

    public EntityAIAttackRangedCustomMutex(T attacker, int intervalMin, int maxAttackTime, float maxAttackDistanceIn, int mutex) {
        this.entity = attacker;
        this.rangedAttackTime = -1;
        this.attackIntervalMin = intervalMin;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.func_75248_a(mutex);
    }

    public boolean func_75250_a() {
        EntityLivingBase check = this.entity.func_70638_az();
        if (check == null) {
            return false;
        }
        this.target = check;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double dist = this.entity.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        boolean sight = this.entity.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = sight ? ++this.seeTime : 0;
        if (--this.rangedAttackTime == 0) {
            if (sight) {
                float ratio = MathHelper.func_76133_a((double)dist) / this.attackRadius;
                float clampedRatio = MathHelper.func_76131_a((float)ratio, (float)0.1f, (float)1.0f);
                ((IRangedAttackMob)this.entity).func_82196_d(this.target, clampedRatio);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(ratio * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        } else if (this.rangedAttackTime < 0) {
            float ratio = MathHelper.func_76133_a((double)dist) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(ratio * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

