/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;

public class EntityTAGolemOrb
extends EntityThrowable {
    protected static final DataParameter<Boolean> RED = EntityDataManager.func_187226_a(EntityTAGolemOrb.class, (DataSerializer)DataSerializers.field_187198_h);
    protected WeakReference<EntityLivingBase> target;
    protected UUID targetID;

    public EntityTAGolemOrb(World world) {
        super(world);
        this.target = new WeakReference<Object>(null);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityTAGolemOrb(World world, EntityLivingBase shooter, EntityLivingBase targetEntity, boolean red) {
        super(world, shooter);
        this.target = new WeakReference<EntityLivingBase>(targetEntity);
        this.field_70180_af.func_187227_b(RED, (Object)red);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RED, (Object)false);
    }

    public boolean isRed() {
        return (Boolean)this.field_70180_af.func_187225_a(RED);
    }

    public void setRed(boolean red) {
        this.field_70180_af.func_187227_b(RED, (Object)red);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.field_70192_c != null && result.field_72313_a == RayTraceResult.Type.ENTITY) {
            result.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.field_70192_c), (float)this.field_70192_c.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * (this.isRed() ? 1.0f : 0.0f));
        } else if (this.field_70170_p.field_72995_K) {
            ThaumicAugmentation.proxy.getRenderHelper().renderBurst(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 0xFFFFFF);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundsTC.shock, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.func_70106_y();
        }
    }

    protected int getLifespan() {
        if (this.isRed()) {
            return Math.max(100, 120 * this.field_70170_p.func_175659_aa().func_151525_a());
        }
        return Math.max(60, 80 * this.field_70170_p.func_175659_aa().func_151525_a());
    }

    protected double getPull(double currentVelocity, double dd) {
        double pull = 0.125 * (double)this.field_70170_p.func_175659_aa().func_151525_a();
        if (Math.signum(currentVelocity) != Math.signum(dd)) {
            pull *= 2.0;
        }
        return pull;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            List found;
            if (this.targetID != null && !(found = this.field_70170_p.func_175644_a(EntityLivingBase.class, e -> e != null && e.func_110124_au().equals(this.targetID))).isEmpty()) {
                this.target = new WeakReference(found.get(0));
                this.targetID = null;
            }
            EntityLivingBase entity = (EntityLivingBase)this.target.get();
            if (this.field_70173_aa > this.getLifespan()) {
                this.func_70106_y();
            } else if (entity != null) {
                if (!entity.func_70089_S()) {
                    this.target.clear();
                } else {
                    double dist = this.func_70068_e((Entity)entity);
                    double dx = (entity.field_70165_t - this.field_70165_t) / dist;
                    double dy = (entity.field_70163_u + (double)entity.func_70047_e() - this.field_70163_u) / dist;
                    double dz = (entity.field_70161_v - this.field_70161_v) / dist;
                    this.field_70159_w += dx * this.getPull(this.field_70159_w, dx);
                    this.field_70181_x += dy * this.getPull(this.field_70181_x, dy);
                    this.field_70179_y += dz * this.getPull(this.field_70179_y, dz);
                    this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.3f, (double)0.3f);
                    this.field_70181_x = MathHelper.func_151237_a((double)this.field_70181_x, (double)-0.3f, (double)0.3f);
                    this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.3f, (double)0.3f);
                    this.func_70018_K();
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity hitter = source.func_76346_g();
        if (hitter == null) {
            hitter = source.func_76364_f();
        }
        if (hitter != null) {
            Vec3d hit = hitter.func_70040_Z();
            this.field_70159_w = hit.field_72450_a * 0.9;
            this.field_70181_x = hit.field_72448_b * 0.9;
            this.field_70179_y = hit.field_72449_c * 0.9;
            this.func_184185_a(SoundsTC.zap, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.func_70018_K();
            return true;
        }
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.targetID = compound.func_186857_a("target");
        this.field_70180_af.func_187227_b(RED, (Object)compound.func_74767_n("red"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        EntityLivingBase t = (EntityLivingBase)this.target.get();
        if (t != null) {
            compound.func_186854_a("target", t.func_110124_au());
        }
        compound.func_74757_a("red", ((Boolean)this.field_70180_af.func_187225_a(RED)).booleanValue());
    }
}

