/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.IAltarBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IObeliskType;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileAltar;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockCapstone
extends BlockTABase
implements IItemBlockProvider,
IObeliskType,
IAltarBlock {
    public BlockCapstone() {
        super(Material.field_151576_e);
        this.func_149711_c(-1.0f);
        this.func_149752_b(6000000.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)IObeliskType.ObeliskType.ELDRITCH)).func_177226_a((IProperty)IAltarBlock.ALTAR, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemMultiTexture(this, null, new String[]{"capstone_eldritch", "capstone_ancient", "altar_eldritch", "altar_ancient"}){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                if (!TAConfig.disableCreativeOnlyText.getValue().booleanValue()) {
                    tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.creative_only", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)).func_150254_d());
                }
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IObeliskType.OBELISK_TYPE, IAltarBlock.ALTAR});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((IObeliskType.ObeliskType)((Object)state.func_177229_b(IObeliskType.OBELISK_TYPE))).getMeta();
        return meta |= (Boolean)state.func_177229_b((IProperty)IAltarBlock.ALTAR) != false ? 2 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)IObeliskType.ObeliskType.fromMeta(BitUtil.getBits(meta, 0, 1))));
        return state.func_177226_a((IProperty)IAltarBlock.ALTAR, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 1)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IAltarBlock.ALTAR);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)IAltarBlock.ALTAR)).booleanValue()) {
            return new TileAltar();
        }
        return null;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < 4; ++i) {
                items.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    protected <T extends Comparable<T>> String getPropName(IProperty<T> prop, Comparable<?> comp) {
        return prop.func_177702_a(comp);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < 4; ++i) {
            IBlockState state = this.func_176203_a(i);
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                if (builder.length() != 0) {
                    builder.append(",");
                }
                IProperty property = (IProperty)entry.getKey();
                builder.append(property.func_177701_a());
                builder.append("=");
                builder.append(this.getPropName(property, (Comparable)entry.getValue()));
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), builder.toString()));
        }
    }
}

