/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IUnwardableBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardOpenedBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardParticles;
import thecodex6824.thaumicaugmentation.api.block.property.door.IArcaneDoorHalf;
import thecodex6824.thaumicaugmentation.api.block.property.door.IArcaneDoorHinge;
import thecodex6824.thaumicaugmentation.api.block.property.door.IArcaneDoorOpen;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.tile.TileArcaneDoor;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockArcaneDoor
extends BlockTABase
implements IHorizontallyDirectionalBlock,
IArcaneDoorHalf,
IArcaneDoorHinge,
IArcaneDoorOpen,
IUnwardableBlock,
IWardParticles {
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    private int assignedMeta;

    public BlockArcaneDoor(Material mat, int meta) {
        super(mat);
        this.assignedMeta = meta;
        this.func_149722_s();
        this.func_149752_b(2.1267647E37f);
        IBlockState state = this.field_176227_L.func_177621_b();
        state = state.func_177226_a(IArcaneDoorHalf.DOOR_HALF, (Comparable)((Object)IArcaneDoorHalf.ArcaneDoorHalf.LOWER));
        state = state.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(false));
        state = state.func_177226_a(IArcaneDoorHinge.HINGE_SIDE, (Comparable)BlockDoor.EnumHingePosition.LEFT);
        this.func_180632_j(state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((state = this.func_176221_a(state, source, pos)).func_177230_c() == this) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
            boolean flag = (Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN) == false;
            boolean flag1 = state.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) == BlockDoor.EnumHingePosition.RIGHT;
            switch (enumfacing) {
                default: {
                    return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
                }
                case SOUTH: {
                    return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
                }
                case WEST: {
                    return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
                }
                case NORTH: 
            }
            return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
        }
        return SOUTH_AABB;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER ? ((Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN)).booleanValue() : ((Boolean)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN)).booleanValue();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IArcaneDoorHalf.DOOR_HALF, IHorizontallyDirectionalBlock.DIRECTION, IArcaneDoorOpen.DOOR_OPEN, IArcaneDoorHinge.HINGE_SIDE, IWardOpenedBlock.WARD_OPENED});
    }

    protected SoundEvent getOpenSound(IBlockState state) {
        return this.field_149764_J == Material.field_151573_f ? SoundEvents.field_187611_cI : SoundEvents.field_187875_gN;
    }

    protected SoundEvent getCloseSound(IBlockState state) {
        return this.field_149764_J == Material.field_151573_f ? SoundEvents.field_187608_cH : SoundEvents.field_187873_gM;
    }

    public SoundType func_185467_w() {
        return this.field_149764_J == Material.field_151573_f ? SoundType.field_185852_e : SoundType.field_185848_a;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            IWardedTile warded;
            IBlockState upper;
            BlockPos blockpos = state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER ? pos : pos.func_177977_b();
            IBlockState lower = pos.equals((Object)blockpos) ? state : world.func_180495_p(blockpos);
            IBlockState iBlockState = upper = pos.equals((Object)blockpos.func_177984_a()) ? state : world.func_180495_p(blockpos.func_177984_a());
            if (lower.func_177230_c() != this) {
                return false;
            }
            TileEntity tile = world.func_175625_s(blockpos);
            if (tile != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && warded.hasPermission((EntityLivingBase)player)) {
                state = lower.func_177231_a((IProperty)IArcaneDoorOpen.DOOR_OPEN);
                world.func_180501_a(blockpos, state, 3);
                world.func_175704_b(blockpos, pos);
                world.func_184133_a(null, blockpos, (Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN) != false ? this.getOpenSound(state) : this.getCloseSound(state), SoundCategory.BLOCKS, 1.0f, 1.0f);
                EnumFacing doorFacing = (EnumFacing)upper.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
                EnumFacing offset = state.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) == BlockDoor.EnumHingePosition.LEFT ? doorFacing.func_176746_e() : doorFacing.func_176735_f();
                IBlockState otherDoorLower = world.func_180495_p(blockpos.func_177972_a(offset));
                if (otherDoorLower.func_177230_c() == this && otherDoorLower.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER && otherDoorLower.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN) == lower.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN) && otherDoorLower.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) != lower.func_177229_b(IArcaneDoorHinge.HINGE_SIDE)) {
                    otherDoorLower.func_177230_c().func_180639_a(world, blockpos.func_177972_a(offset), otherDoorLower, player, hand, facing, hitX, hitY, hitZ);
                }
                return true;
            }
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        boolean isLower = !BitUtil.isBitSet(meta, 0);
        state = state.func_177226_a(IArcaneDoorHalf.DOOR_HALF, (Comparable)((Object)(isLower ? IArcaneDoorHalf.ArcaneDoorHalf.LOWER : IArcaneDoorHalf.ArcaneDoorHalf.UPPER)));
        if (isLower) {
            state = state.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 1)));
            state = state.func_177226_a(IArcaneDoorHinge.HINGE_SIDE, (Comparable)(BitUtil.isBitSet(meta, 2) ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT));
        } else {
            state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_176731_b((int)BitUtil.getBits(meta, 1, 3)));
            state = state.func_177226_a((IProperty)IWardOpenedBlock.WARD_OPENED, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 3)));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta = BitUtil.setBit(meta, 0, state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.UPPER);
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER) {
            meta = BitUtil.setBit(meta, 1, (Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN));
            meta = BitUtil.setBit(meta, 2, state.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) == BlockDoor.EnumHingePosition.RIGHT);
        } else {
            meta = BitUtil.setBits(meta, 1, 3, ((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)).func_176736_b());
            meta = BitUtil.setBit(meta, 3, (Boolean)state.func_177229_b((IProperty)IWardOpenedBlock.WARD_OPENED));
        }
        return meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            IBlockState upper = world.func_180495_p(pos.func_177984_a());
            return state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, upper.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)).func_177226_a((IProperty)IWardOpenedBlock.WARD_OPENED, upper.func_177229_b((IProperty)IWardOpenedBlock.WARD_OPENED));
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            IBlockState lower = world.func_180495_p(pos.func_177977_b());
            state = state.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, lower.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN));
            state = state.func_177226_a(IArcaneDoorHinge.HINGE_SIDE, lower.func_177229_b(IArcaneDoorHinge.HINGE_SIDE));
            return state;
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean removed = false;
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
                world.func_175698_g(pos);
                removed = true;
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            world.func_175698_g(pos);
            removed = true;
        }
        if (!removed) {
            IWardedTile warded;
            IBlockState lower;
            BlockPos openPos = pos;
            BlockPos powerPos = pos;
            IBlockState setOpenOn = state;
            IBlockState setPoweredOn = state;
            if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER) {
                IBlockState upper = world.func_180495_p(pos.func_177984_a());
                if (upper.func_177230_c() == this) {
                    setPoweredOn = upper;
                    powerPos = pos.func_177984_a();
                }
            } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this && (lower = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
                setOpenOn = lower;
                openPos = pos.func_177977_b();
            }
            TileEntity tile = world.func_175625_s(openPos);
            if (tile != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
                boolean shouldOpen = WardHelper.isOpenedByWardOpeningBlock(world, openPos.equals((Object)pos) ? openPos : powerPos, warded.getOwner());
                if (!shouldOpen) {
                    shouldOpen = WardHelper.isOpenedByWardOpeningBlock(world, openPos.equals((Object)pos) ? powerPos : openPos, warded.getOwner());
                }
                if (!shouldOpen) {
                    IWardedTile wardedOther;
                    TileEntity otherDoorTile;
                    EnumFacing doorFacing = (EnumFacing)world.func_180495_p(powerPos).func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
                    IBlockState lower2 = world.func_180495_p(openPos);
                    EnumFacing offset = lower2.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) == BlockDoor.EnumHingePosition.LEFT ? doorFacing.func_176746_e() : doorFacing.func_176735_f();
                    BlockPos otherDoor = openPos.func_177972_a(offset);
                    IBlockState otherDoorLower = world.func_180495_p(otherDoor);
                    if (otherDoorLower.func_177230_c() == this && otherDoorLower.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER && ((Boolean)world.func_180495_p(otherDoor.func_177984_a()).func_177229_b((IProperty)IWardOpenedBlock.WARD_OPENED)).booleanValue() && otherDoorLower.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) != lower2.func_177229_b(IArcaneDoorHinge.HINGE_SIDE) && (otherDoorTile = world.func_175625_s(otherDoor)) != null && (wardedOther = (IWardedTile)otherDoorTile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && wardedOther.getOwner().equals(warded.getOwner()) && !(shouldOpen = WardHelper.isOpenedByWardOpeningBlock(world, otherDoor, wardedOther.getOwner()))) {
                        shouldOpen = WardHelper.isOpenedByWardOpeningBlock(world, otherDoor.func_177984_a(), wardedOther.getOwner());
                    }
                }
                if (shouldOpen != (Boolean)setPoweredOn.func_177229_b((IProperty)IWardOpenedBlock.WARD_OPENED)) {
                    world.func_180501_a(powerPos, setPoweredOn.func_177226_a((IProperty)IWardOpenedBlock.WARD_OPENED, (Comparable)Boolean.valueOf(shouldOpen)), 3);
                    if (shouldOpen != (Boolean)setOpenOn.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN)) {
                        world.func_180501_a(openPos, setOpenOn.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(shouldOpen)), 3);
                        world.func_184133_a(null, openPos, shouldOpen ? this.getOpenSound(state) : this.getCloseSound(state), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.UPPER) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                worldIn.func_175698_g(pos.func_177977_b());
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER) {
            drops.add((Object)new ItemStack(TAItems.ARCANE_DOOR, 1, this.assignedMeta));
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER) {
            return new ItemStack(TAItems.ARCANE_DOOR, 1, this.assignedMeta);
        }
        IBlockState below = worldIn.func_180495_p(pos.func_177977_b());
        if (below.func_177230_c() == this) {
            return new ItemStack(TAItems.ARCANE_DOOR, 1, this.assignedMeta);
        }
        return ItemStack.field_190927_a;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IWardedTile warded;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            warded.setOwner(placer.func_110124_au());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)player)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.LOWER;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileArcaneDoor();
    }
}

