/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public final class MorphicArmorExclusions {
    protected static final List<ModelPattern> EXCLUDED = new ArrayList<ModelPattern>();

    private MorphicArmorExclusions() {
    }

    public static boolean addExcludedModelPattern(String variantPattern) {
        return EXCLUDED.add(new ModelPattern(variantPattern));
    }

    public static boolean isModelExcluded(String variant) {
        for (ModelPattern mp : EXCLUDED) {
            Predicate<String> p = mp.getExpr();
            if (p != null && p.test(variant)) {
                return true;
            }
            if (p != null || !mp.getRawString().equals(variant)) continue;
            return true;
        }
        return false;
    }

    public static boolean removeExcludedModelPattern(String variantPattern) {
        return EXCLUDED.removeIf(p -> p.getRawString().equals(variantPattern));
    }

    public static void removeAllExcludedModelPatterns() {
        EXCLUDED.clear();
    }

    private static class ModelPattern {
        protected Predicate<String> regex;
        protected String original;

        public ModelPattern(String p) {
            this.original = p;
            try {
                this.regex = Pattern.compile(this.original).asPredicate();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        @Nullable
        public Predicate<String> getExpr() {
            return this.regex;
        }

        public String getRawString() {
            return this.original;
        }
    }
}

