/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.event;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.casters.ICaster;
import thaumcraft.client.fx.ParticleEngine;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.client.ImpetusRenderingManager;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.item.CapabilityImpetusLinker;
import thecodex6824.thaumicaugmentation.api.item.CapabilityMorphicTool;
import thecodex6824.thaumicaugmentation.api.item.IImpetusLinker;
import thecodex6824.thaumicaugmentation.api.item.IMorphicTool;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.api.util.RaytraceHelper;
import thecodex6824.thaumicaugmentation.client.fx.FXImpulseBeam;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TATextures;
import thecodex6824.thaumicaugmentation.client.shader.TAShaderManager;
import thecodex6824.thaumicaugmentation.client.shader.TAShaders;
import thecodex6824.thaumicaugmentation.client.sound.SoundHandleSpecialSound;
import thecodex6824.thaumicaugmentation.common.block.trait.INoBlockOutline;
import thecodex6824.thaumicaugmentation.common.util.IShaderRenderingCallback;
import thecodex6824.thaumicaugmentation.common.util.ISoundHandle;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;
import thecodex6824.thaumicaugmentation.common.util.ShaderType;

@Mod.EventBusSubscriber(modid="thaumicaugmentation", value={Side.CLIENT})
public class RenderEventHandler {
    private static final Cache<Integer, Boolean> CAST_CACHE = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(3000L, TimeUnit.MILLISECONDS).maximumSize(250L).build();
    private static final Cache<EntityLivingBase, FXImpulseBeam> IMPULSE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(3000L, TimeUnit.MILLISECONDS).weakKeys().maximumSize(50L).removalListener(k -> ((FXImpulseBeam)((Object)((Object)k.getValue()))).func_187112_i()).build();
    private static final Object2LongMap<DimensionalBlockPos[]> TRANSACTIONS = Object2LongMaps.synchronize((Object2LongMap)new Object2LongOpenHashMap());
    private static final Object2IntOpenHashMap<DimensionalBlockPos> FRAME_COLORS = new Object2IntOpenHashMap();
    private static boolean renderShaders = false;
    private static final ArrayList<ArrayList<IShaderRenderingCallback>> SHADER_RENDERS = new ArrayList(ShaderType.values().length);
    private static final double TRANSACTION_DURATION = 60.0;
    private static NonNullList<ItemStack> tempArmor = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);

    public static void onEntityCast(int id) {
        if (TAConfig.gauntletCastAnimation.getValue().booleanValue()) {
            CAST_CACHE.put((Object)id, (Object)true);
        }
    }

    public static void onImpetusTransaction(DimensionalBlockPos[] positions) {
        TRANSACTIONS.put((Object)positions, Minecraft.func_71410_x().field_71441_e.func_82737_E());
    }

    public static void onRenderShaderTile(ShaderType type, IShaderRenderingCallback tile) {
        SHADER_RENDERS.get(type.getIndex()).add(tile);
        renderShaders = true;
    }

    public static void onImpulseBeam(EntityLivingBase entity, boolean stop) {
        if (stop) {
            FXImpulseBeam beam = (FXImpulseBeam)((Object)IMPULSE_CACHE.getIfPresent((Object)entity));
            if (beam != null) {
                beam.func_187112_i();
            }
            IMPULSE_CACHE.invalidate((Object)entity);
        } else {
            FXImpulseBeam beam = (FXImpulseBeam)((Object)IMPULSE_CACHE.getIfPresent((Object)entity));
            if (beam == null) {
                Vec3d dest = RaytraceHelper.raytracePosition(entity, TAConfig.cannonBeamRange.getValue());
                beam = new FXImpulseBeam(entity.func_130014_f_(), entity, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, 0.35f, 0.35f, 0.65f, Integer.MAX_VALUE);
                beam.setPulse(true);
                beam.setFollowOwner(true);
                beam.setImpactTicks(Integer.MAX_VALUE);
                beam.setEndsLoop(true);
                IMPULSE_CACHE.put((Object)entity, (Object)beam);
                ParticleEngine.addEffect((World)entity.func_130014_f_(), (Particle)beam);
                int id = entity.func_145782_y();
                ISoundHandle handle = ThaumicAugmentation.proxy.playSpecialSound(TASounds.IMPULSE_CANNON_BEAM_LOOP, SoundCategory.PLAYERS, old -> {
                    Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                    if (e != null && !e.field_70128_L && IMPULSE_CACHE.getIfPresent((Object)e) != null) {
                        return e.func_174791_d();
                    }
                    return null;
                }, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, 0.01f, 1.0f, true, 0);
                if (handle instanceof SoundHandleSpecialSound) {
                    SoundHandleSpecialSound s = (SoundHandleSpecialSound)handle;
                    s.setFadeIn(40);
                    if (ThaumicAugmentation.proxy.isEntityRenderView((Entity)entity)) {
                        s.setAttenuationType(ISound.AttenuationType.NONE);
                    }
                }
            }
        }
    }

    @Nullable
    private static EnumHand findCaster(EntityLivingBase entity) {
        for (EnumHand hand : EnumHand.values()) {
            IMorphicTool tool;
            ItemStack stack = entity.func_184586_b(hand);
            if (stack.func_77973_b() instanceof ICaster) {
                return hand;
            }
            if (stack.func_77973_b() != TAItems.MORPHIC_TOOL || (tool = (IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) == null) continue;
            EnumAction action = tool.getDisplayStack().func_77975_n();
            if (!(tool.getFunctionalStack().func_77973_b() instanceof ICaster) || action != EnumAction.NONE && action != EnumAction.BOW) continue;
            return hand;
        }
        return null;
    }

    @Nullable
    private static EnumHand findImpulseCannon(EntityLivingBase entity) {
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_77973_b() == TAItems.IMPULSE_CANNON) {
            return EnumHand.MAIN_HAND;
        }
        stack = entity.func_184592_cb();
        if (stack.func_77973_b() == TAItems.IMPULSE_CANNON) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static void onRotationAngles(ModelBiped model, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EnumHand hand;
            EntityLivingBase living = (EntityLivingBase)entity;
            if (TAConfig.gauntletCastAnimation.getValue().booleanValue() && CAST_CACHE.getIfPresent((Object)living.func_145782_y()) != null && (hand = RenderEventHandler.findCaster(living)) != null && model instanceof ModelBiped) {
                EnumHandSide side = living.func_184591_cq();
                if (hand == EnumHand.OFF_HAND) {
                    side = side.func_188468_a();
                }
                if (side == EnumHandSide.RIGHT) {
                    model.field_178723_h.field_78795_f = -1.5707963f + model.field_78116_c.field_78795_f;
                    model.field_178723_h.field_78796_g = model.field_78116_c.field_78796_g;
                    model.field_178723_h.field_78808_h = model.field_78116_c.field_78808_h;
                } else {
                    model.field_178724_i.field_78795_f = -1.5707963f + model.field_78116_c.field_78795_f;
                    model.field_178724_i.field_78796_g = model.field_78116_c.field_78796_g;
                    model.field_178724_i.field_78808_h = model.field_78116_c.field_78808_h;
                }
                return;
            }
            hand = RenderEventHandler.findImpulseCannon(living);
            if (hand != null) {
                EnumHand oppositeHand = hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
                EnumHandSide side = living.func_184591_cq();
                if (hand == EnumHand.OFF_HAND) {
                    side = side.func_188468_a();
                }
                if (side == EnumHandSide.RIGHT) {
                    model.field_178723_h.field_78795_f = -1.5707963f + model.field_78116_c.field_78795_f;
                    model.field_178723_h.field_78796_g = model.field_78116_c.field_78796_g;
                    model.field_178723_h.field_78808_h = model.field_78116_c.field_78808_h;
                    if (living.func_184586_b(oppositeHand).func_190926_b()) {
                        model.field_178724_i.field_78795_f = -1.5707963f + model.field_78116_c.field_78795_f;
                        model.field_178724_i.field_78796_g = model.field_78116_c.field_78796_g + 0.62831855f;
                        model.field_178724_i.field_78808_h = model.field_78116_c.field_78808_h;
                    }
                } else {
                    model.field_178724_i.field_78795_f = -1.5707963f + model.field_78116_c.field_78795_f;
                    model.field_178724_i.field_78796_g = model.field_78116_c.field_78796_g;
                    model.field_178724_i.field_78808_h = model.field_78116_c.field_78808_h;
                    if (living.func_184586_b(oppositeHand).func_190926_b()) {
                        model.field_178723_h.field_78795_f = -1.5707963f + model.field_78116_c.field_78795_f;
                        model.field_178723_h.field_78796_g = model.field_78116_c.field_78796_g - 0.62831855f;
                        model.field_178723_h.field_78808_h = model.field_78116_c.field_78808_h;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<EntityLivingBase> event) {
        List<ItemStack> armor = MorphicArmorHelper.getArmorInventory(event.getEntity());
        for (int i = 0; i < armor.size(); ++i) {
            ItemStack s = armor.get(i);
            ItemStack disp = MorphicArmorHelper.getMorphicArmor(s);
            if (disp.func_190926_b()) continue;
            tempArmor.set(i, (Object)s);
            armor.set(i, disp);
        }
    }

    private static void restoreArmor(EntityLivingBase entity) {
        List<ItemStack> armor = MorphicArmorHelper.getArmorInventory(entity);
        for (int i = 0; i < armor.size(); ++i) {
            ItemStack s = (ItemStack)tempArmor.get(i);
            if (s.func_190926_b()) continue;
            armor.set(i, s);
            tempArmor.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderLivingPreCheck(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (event.isCanceled()) {
            RenderEventHandler.restoreArmor(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
        RenderEventHandler.restoreArmor(event.getEntity());
    }

    @SubscribeEvent
    public static void onRenderBlockOutline(DrawBlockHighlightEvent event) {
        if (event.getTarget().func_178782_a() != null && event.getPlayer().func_130014_f_().func_180495_p(event.getTarget().func_178782_a()).func_177230_c() instanceof INoBlockOutline) {
            event.setCanceled(true);
        }
    }

    private static Vec3d rotate(Vec3d input, double angle, Vec3d axis) {
        double sin = Math.sin(angle * 0.5);
        Vector4d vec = new Vector4d(axis.field_72450_a * sin, axis.field_72448_b * sin, axis.field_72449_c * sin, Math.cos(angle * 0.5));
        double d = -vec.x * input.field_72450_a - vec.y * input.field_72448_b - vec.z * input.field_72449_c;
        double d1 = vec.w * input.field_72450_a + vec.y * input.field_72449_c - vec.z * input.field_72448_b;
        double d2 = vec.w * input.field_72448_b - vec.x * input.field_72449_c + vec.z * input.field_72450_a;
        double d3 = vec.w * input.field_72449_c + vec.x * input.field_72448_b - vec.y * input.field_72450_a;
        return new Vec3d(d1 * vec.w - d * vec.x - d2 * vec.z + d3 * vec.y, d2 * vec.w - d * vec.y + d1 * vec.z - d3 * vec.x, d3 * vec.w - d * vec.z - d1 * vec.y + d2 * vec.x);
    }

    private static void renderNormalBeam(Entity rv, float partial, Vec3d from, Vec3d to) {
        Vec3d se = to.func_178788_d(from);
        Vec3d axis = (se.field_72449_c == 0.0 ? new Vec3d(se.field_72448_b, -se.field_72450_a, 0.0) : new Vec3d(0.0, se.field_72449_c, -se.field_72448_b)).func_72432_b();
        double dist = from.func_72438_d(to);
        double offset = (double)(rv.field_70173_aa % 100) / 100.0 + (double)partial / 100.0;
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.BEAM);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        double angle = 0.0;
        for (int i = 0; i < 4; ++i) {
            Vec3d perpendicular = RenderEventHandler.rotate(axis, angle, se).func_72432_b().func_186678_a(0.0625);
            Vec3d p1 = from.func_178787_e(perpendicular);
            Vec3d p2 = to.func_178787_e(perpendicular);
            Vec3d p3 = to.func_178788_d(perpendicular);
            Vec3d p4 = from.func_178788_d(perpendicular);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0 - offset, 0.0).func_181666_a(0.4f, 0.4f, 0.5f, 0.65f).func_181675_d();
            buffer.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_187315_a(dist - offset, 0.0).func_181666_a(0.4f, 0.4f, 0.5f, 0.65f).func_181675_d();
            buffer.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_187315_a(dist - offset, 1.0).func_181666_a(0.4f, 0.4f, 0.5f, 0.65f).func_181675_d();
            buffer.func_181662_b(p4.field_72450_a, p4.field_72448_b, p4.field_72449_c).func_187315_a(1.0 - offset, 1.0).func_181666_a(0.4f, 0.4f, 0.5f, 0.65f).func_181675_d();
            t.func_78381_a();
            angle += 0.1308996938995747;
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private static void renderStrongLaser(Entity rv, float partial, Vec3d eyePos, Vec3d from, Vec3d to, double factor) {
        Vec3d se = to.func_178788_d(from);
        Vec3d axis = (se.field_72449_c == 0.0 ? new Vec3d(se.field_72448_b, -se.field_72450_a, 0.0) : new Vec3d(0.0, se.field_72449_c, -se.field_72448_b)).func_72432_b();
        double dist = from.func_72438_d(to);
        double offset = (double)(rv.field_70173_aa % 100) / 100.0 + (double)partial / 100.0;
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.LASER);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        double angle = 0.0;
        for (int i = 0; i < 4; ++i) {
            Vec3d perpendicular = RenderEventHandler.rotate(axis, angle, se).func_72432_b().func_186678_a(0.4275);
            Vec3d p1 = from.func_178787_e(perpendicular);
            Vec3d p2 = to.func_178787_e(perpendicular);
            Vec3d p3 = to.func_178788_d(perpendicular);
            Vec3d p4 = from.func_178788_d(perpendicular);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0 - offset, 0.0).func_181666_a(0.35f, 0.35f, 0.5f, (float)factor).func_181675_d();
            buffer.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_187315_a(dist - offset, 0.0).func_181666_a(0.35f, 0.35f, 0.5f, (float)factor).func_181675_d();
            buffer.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_187315_a(dist - offset, 1.0).func_181666_a(0.35f, 0.35f, 0.5f, (float)factor).func_181675_d();
            buffer.func_181662_b(p4.field_72450_a, p4.field_72448_b, p4.field_72449_c).func_187315_a(1.0 - offset, 1.0).func_181666_a(0.35f, 0.35f, 0.5f, (float)factor).func_181675_d();
            t.func_78381_a();
            angle += 0.7853981633974483;
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private static void renderCubeFrame(Entity rv, float partial, Vec3d eyePos, BlockPos blockPosition, AxisAlignedBB cube, float r, float g, float b, float a) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        Vec3d pos = new Vec3d((Vec3i)blockPosition);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.FRAME);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c + 1.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b + 1.0, pos.field_72449_c + 1.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c + 1.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b, pos.field_72449_c + 1.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b, pos.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b + 1.0, pos.field_72449_c + 1.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b + 1.0, pos.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c + 1.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c + 1.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b, pos.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(pos.field_72450_a + 1.0, pos.field_72448_b + 1.0, pos.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
    }

    public static void onRenderEntities(int pass) {
        if (pass == 0) {
            float pt = ThaumicAugmentation.proxy.isSingleplayer() && Minecraft.func_71410_x().func_147113_T() ? 0.0f : Minecraft.func_71410_x().func_184121_ak();
            Entity rv = Minecraft.func_71410_x().func_175606_aa() != null ? Minecraft.func_71410_x().func_175606_aa() : Minecraft.func_71410_x().field_71439_g;
            double rX = rv.field_70142_S + (rv.field_70165_t - rv.field_70142_S) * (double)pt;
            double rY = rv.field_70137_T + (rv.field_70163_u - rv.field_70137_T) * (double)pt;
            double rZ = rv.field_70136_U + (rv.field_70161_v - rv.field_70136_U) * (double)pt;
            if (renderShaders) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179089_o();
                for (ShaderType type : ShaderType.values()) {
                    ArrayList<IShaderRenderingCallback> toRender = SHADER_RENDERS.get(type.getIndex());
                    if (toRender.isEmpty()) continue;
                    switch (type.getIndex()) {
                        case 0: {
                            if (TAShaderManager.shouldUseShaders()) {
                                TAShaderManager.enableShader(TAShaders.FLUX_RIFT, TAShaders.SHADER_CALLBACK_GENERIC_SPHERE);
                            } else {
                                GlStateManager.func_179131_c((float)0.1f, (float)0.4f, (float)0.5f, (float)1.0f);
                            }
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.RIFT);
                            break;
                        }
                        case 1: {
                            if (TAShaderManager.shouldUseShaders()) {
                                TAShaderManager.enableShader(TAShaders.FRACTURE, TAShaders.SHADER_CALLBACK_GENERIC_SPHERE);
                            } else {
                                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            }
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.EMPTINESS_SKY);
                            break;
                        }
                        case 2: {
                            if (TAShaderManager.shouldUseShaders()) {
                                TAShaderManager.enableShader(TAShaders.MIRROR, TAShaders.SHADER_CALLBACK_GENERIC_SPHERE);
                            } else {
                                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            }
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.MIRROR);
                            break;
                        }
                        default: {
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.RIFT);
                        }
                    }
                    for (IShaderRenderingCallback tile : toRender) {
                        tile.renderWithShader(type, rX, rY, rZ);
                    }
                    if (TAShaderManager.shouldUseShaders()) {
                        TAShaderManager.disableShader();
                    } else {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    toRender.clear();
                }
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GlStateManager.func_179129_p();
                GlStateManager.func_179145_e();
                renderShaders = false;
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Entity rv = Minecraft.func_71410_x().func_175606_aa() != null ? Minecraft.func_71410_x().func_175606_aa() : Minecraft.func_71410_x().field_71439_g;
        Vec3d eyePos = rv.func_174824_e(event.getPartialTicks());
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-(rv.field_70142_S + (rv.field_70165_t - rv.field_70142_S) * (double)event.getPartialTicks())), (double)(-(rv.field_70137_T + (rv.field_70163_u - rv.field_70137_T) * (double)event.getPartialTicks())), (double)(-(rv.field_70136_U + (rv.field_70161_v - rv.field_70136_U) * (double)event.getPartialTicks())));
        Collection<IImpetusNode> nodes = ImpetusRenderingManager.getAllRenderableNodes(world.field_73011_w.getDimension());
        if (!nodes.isEmpty()) {
            List renderNodes = nodes.stream().filter(node -> {
                if (!world.func_175667_e(node.getLocation().getPos())) return false;
                TileEntity tile = world.func_175625_s(node.getLocation().getPos());
                if (tile == null) return false;
                if (!tile.hasCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) return false;
                Vec3d vec3d = new Vec3d((Vec3i)node.getLocation().getPos());
                if (!(eyePos.func_72436_e(vec3d) < 16384.0)) return false;
                return true;
            }).sorted(Comparator.comparingDouble(node -> eyePos.func_72436_e(new Vec3d((Vec3i)node.getLocation().getPos()))).reversed()).collect(Collectors.toList());
            for (IImpetusNode node2 : renderNodes) {
                for (IImpetusNode out : node2.getOutputs()) {
                    if (!node2.shouldPhysicalBeamLinkTo(out) || !out.shouldPhysicalBeamLinkTo(node2)) continue;
                    RenderEventHandler.renderNormalBeam(rv, event.getPartialTicks(), node2.getBeamEndpoint(), out.getBeamEndpoint());
                }
            }
        }
        long time = world.func_82737_E();
        ObjectIterator iterator = TRANSACTIONS.object2LongEntrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            DimensionalBlockPos[] array = (DimensionalBlockPos[])entry.getKey();
            long passed = time - (Long)entry.getValue();
            if (passed < 0L || (double)passed > 60.0) {
                iterator.remove();
                continue;
            }
            for (int i = 0; i < array.length - 1; ++i) {
                IImpetusNode start = ImpetusRenderingManager.findNodeByPosition(array[i]);
                IImpetusNode end = ImpetusRenderingManager.findNodeByPosition(array[i + 1]);
                if (start == null || end == null || !start.shouldPhysicalBeamLinkTo(end) || !end.shouldPhysicalBeamLinkTo(start)) continue;
                RenderEventHandler.renderStrongLaser(rv, event.getPartialTicks(), eyePos, start.getBeamEndpoint(), end.getBeamEndpoint(), 1.0 - (double)passed / 60.0);
            }
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (ItemStack stack : player.func_184214_aD()) {
            IImpetusNode cap;
            BlockPos pos;
            DimensionalBlockPos dimPos;
            IImpetusLinker linker = (IImpetusLinker)stack.getCapability(CapabilityImpetusLinker.IMPETUS_LINKER, null);
            if (linker == null || (dimPos = linker.getOrigin()).isInvalid() || player.field_71093_bK != dimPos.getDimension() || !world.func_175667_e(pos = dimPos.getPos()) || world.func_175625_s(pos) == null || (cap = (IImpetusNode)world.func_175625_s(pos).getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) == null) continue;
            Vec3d eyes = player.func_174824_e(event.getPartialTicks());
            if (pos.func_177954_c(eyes.field_72450_a, eyes.field_72448_b, eyes.field_72449_c) < 4096.0) {
                RenderEventHandler.renderCubeFrame(rv, event.getPartialTicks(), rv.func_174824_e(event.getPartialTicks()), pos, player.field_70170_p.func_180495_p(pos).func_185900_c((IBlockAccess)player.field_70170_p, pos), 0.8f, 0.8f, 1.0f, 1.0f);
            }
            FRAME_COLORS.clear();
            for (DimensionalBlockPos p : cap.getInputLocations()) {
                FRAME_COLORS.addTo((Object)p, 1);
            }
            for (DimensionalBlockPos p : cap.getOutputLocations()) {
                FRAME_COLORS.addTo((Object)p, 2);
            }
            for (DimensionalBlockPos p : FRAME_COLORS.keySet()) {
                if (p.getDimension() != player.field_71093_bK || !(p.getPos().func_177954_c(eyes.field_72450_a, eyes.field_72448_b, eyes.field_72449_c) < 4096.0)) continue;
                int color = FRAME_COLORS.getInt((Object)p);
                float r = 0.8f;
                float g = 0.8f;
                float b = 0.8f;
                float a = 0.8f;
                switch (color) {
                    case 1: {
                        r = 1.0f;
                        break;
                    }
                    case 2: {
                        g = 1.0f;
                        break;
                    }
                    default: {
                        r = 1.0f;
                        b = 1.0f;
                    }
                }
                RenderEventHandler.renderCubeFrame(rv, event.getPartialTicks(), rv.func_174824_e(event.getPartialTicks()), p.getPos(), player.field_70170_p.func_180495_p(p.getPos()).func_185900_c((IBlockAccess)player.field_70170_p, p.getPos()), r, g, b, a);
            }
        }
        ArrayList toRemove = new ArrayList();
        for (Map.Entry entry : IMPULSE_CACHE.asMap().entrySet()) {
            if (RenderEventHandler.findImpulseCannon((EntityLivingBase)entry.getKey()) != null) {
                Vec3d dest = RaytraceHelper.raytracePosition((EntityLivingBase)entry.getKey(), (double)TAConfig.cannonBeamRange.getValue(), event.getPartialTicks());
                ((FXImpulseBeam)((Object)entry.getValue())).updateBeamTarget(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
                continue;
            }
            toRemove.add(entry.getKey());
        }
        for (EntityLivingBase e : toRemove) {
            IMPULSE_CACHE.invalidate((Object)e);
        }
        GlStateManager.func_179121_F();
    }

    static {
        for (int i = 0; i < ShaderType.values().length; ++i) {
            SHADER_RENDERS.add(new ArrayList());
        }
    }
}

