/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.ward;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;

public final class WardSyncManager {
    private static Multimap<DimensionalChunkPos, WardUpdateEntry> entries = MultimapBuilder.hashKeys().arrayListValues(16).build();

    private WardSyncManager() {
    }

    public static void markChunkForFullSync(World world, BlockPos pos) {
        WardSyncManager.markPosForNewOwner(world, pos, null);
    }

    public static void markPosForClear(World world, BlockPos pos) {
        WardSyncManager.markPosForNewOwner(world, pos, IWardStorageServer.NIL_UUID);
    }

    public static void markPosForNewOwner(World world, BlockPos pos, UUID newOwner) {
        entries.put((Object)new DimensionalChunkPos(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4), (Object)new WardUpdateEntry(pos.func_185334_h(), newOwner));
    }

    public static Collection<Map.Entry<DimensionalChunkPos, WardUpdateEntry>> getEntries() {
        return entries.entries();
    }

    public static void clearEntries() {
        entries.clear();
    }

    public static class WardUpdateEntry {
        public final BlockPos pos;
        @Nullable
        public final UUID update;

        public WardUpdateEntry(BlockPos p, UUID data) {
            this.pos = p;
            this.update = data;
        }
    }

    public static class DimensionalChunkPos {
        public final int dim;
        public final int x;
        public final int z;

        public DimensionalChunkPos(int dim, int x, int z) {
            this.dim = dim;
            this.x = x;
            this.z = z;
        }
    }
}

