/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.block.property;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.util.QuadConsumer;

public interface ITAStoneType {
    public static final PropertyEnum<StoneType> STONE_TYPE = PropertyEnum.func_177709_a((String)"ta_stone_type", StoneType.class);

    public static enum StoneType implements IStringSerializable
    {
        STONE_VOID(0, () -> ThaumcraftMaterials.MATERIAL_TAINT, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151654_J, 0),
        STONE_TAINT_NODECAY(1, () -> ThaumcraftMaterials.MATERIAL_TAINT, () -> SoundsTC.GORE, (w, b, s, r) -> {}, MapColor.field_151654_J, 0),
        SOIL_STONE_TAINT_NODECAY(2, () -> ThaumcraftMaterials.MATERIAL_TAINT, () -> SoundsTC.GORE, (w, b, s, r) -> {
            if (w.func_180495_p(b.func_177984_a()).getLightOpacity((IBlockAccess)w, b.func_177984_a()) > 2) {
                w.func_175656_a(b, s.func_177226_a(STONE_TYPE, (Comparable)((Object)STONE_TAINT_NODECAY)));
            }
        }, MapColor.field_151678_z, 0),
        ANCIENT_RUNES(3, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151650_B, 0),
        ANCIENT_GLYPHS(4, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151650_B, 0),
        ANCIENT_BRICKS(5, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151650_B, 0),
        STONE_CRUSTED(6, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151676_q, 0),
        STONE_CRUSTED_GLOWING(7, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151676_q, 15),
        ANCIENT_PILLAR(8, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151676_q, 0),
        CHISELED_ANCIENT_BRICKS(9, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151650_B, 0),
        ANCIENT_COBBLESTONE(10, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151649_A, 0),
        ANCIENT_LIGHT(11, () -> Material.field_151576_e, () -> SoundType.field_185851_d, (w, b, s, r) -> {}, MapColor.field_151650_B, 15);

        private int meta;
        private Supplier<Material> mat;
        private Supplier<SoundType> sound;
        private QuadConsumer<World, BlockPos, IBlockState, Random> randomTickFunc;
        private MapColor color;
        private int light;

        private StoneType(int m, Supplier<Material> mt, Supplier<SoundType> s, QuadConsumer<World, BlockPos, IBlockState, Random> func, MapColor c, int l) {
            this.meta = m;
            this.mat = mt;
            this.sound = s;
            this.randomTickFunc = func;
            this.color = c;
            this.light = l;
        }

        public int getMeta() {
            return this.meta;
        }

        public Material getMaterial() {
            return this.mat.get();
        }

        public SoundType getSoundType() {
            return this.sound.get();
        }

        public void randomTick(World world, BlockPos pos, IBlockState state, Random random) {
            this.randomTickFunc.accept(world, pos, state, random);
        }

        public MapColor getMapColor() {
            return this.color;
        }

        public int getLightLevel() {
            return this.light;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        @Nullable
        public static StoneType fromMeta(int id) {
            for (StoneType type : StoneType.values()) {
                if (type.getMeta() != id) continue;
                return type;
            }
            return null;
        }
    }
}

