/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.world.spawn;

import com.google.common.base.Predicate;
import it.hurts.metallurgy_reforged.world.spawn.IOreSpawn;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public class BaseOreSpawn
implements IOreSpawn {
    private final Block blockToReplace;
    private final ResourceLocation[] biomes;

    public BaseOreSpawn(Block blockToReplace, String[] biomes) {
        this.blockToReplace = blockToReplace;
        this.biomes = this.parseBiomes(biomes);
    }

    private ResourceLocation[] parseBiomes(String[] biomesResource) {
        if (biomesResource == null) {
            return new ResourceLocation[0];
        }
        ResourceLocation[] resLocations = new ResourceLocation[biomesResource.length];
        for (int i = 0; i < biomesResource.length; ++i) {
            resLocations[i] = new ResourceLocation(biomesResource[i]);
        }
        return resLocations;
    }

    @Override
    public boolean canOreSpawn(Chunk chunk, BlockPos pos, IBlockState state, Random random) {
        return BaseOreSpawn.isInBiome(chunk, pos, this.biomes);
    }

    @Override
    public Predicate<IBlockState> getBlockPredicate() {
        return BlockMatcher.func_177642_a((Block)this.blockToReplace);
    }

    private static boolean isInBiome(Chunk chunk, BlockPos pos, ResourceLocation[] biomes) {
        if (biomes.length == 0) {
            return true;
        }
        for (ResourceLocation biome : biomes) {
            if (!chunk.func_177411_a(pos, chunk.func_177412_p().func_72959_q()).getRegistryName().equals((Object)biome)) continue;
            return true;
        }
        return false;
    }
}

