/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.world.explosive;

import com.google.common.collect.Sets;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketMetallurgyExplosion;
import it.hurts.metallurgy_reforged.proxy.ClientProxy;
import it.hurts.metallurgy_reforged.util.Utils;
import it.hurts.metallurgy_reforged.world.explosive.ExplosiveType;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetallurgyExplosion
extends Explosion {
    private final ExplosiveType type;

    @SideOnly(value=Side.CLIENT)
    public MetallurgyExplosion(World worldIn, @Nullable Entity author, double x, double y, double z, List<BlockPos> affectedPositions, ExplosiveType type) {
        super(worldIn, author, x, y, z, type.strength, type.causesFire, type.damagesTerrain, affectedPositions);
        this.type = type;
    }

    public MetallurgyExplosion(World worldIn, Entity author, double x, double y, double z, ExplosiveType type) {
        super(worldIn, author, x, y, z, type.strength, type.causesFire, type.damagesTerrain);
        this.type = type;
    }

    public static MetallurgyExplosion newExplosion(World world, @Nullable Entity entityIn, double x, double y, double z, ExplosiveType type) {
        MetallurgyExplosion explosion = new MetallurgyExplosion(world, entityIn, x, y, z, type);
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        if (!world.field_72995_K) {
            if (!type.damagesTerrain) {
                explosion.func_180342_d();
            }
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (!(entityplayer.func_70092_e(x, y, z) < 4096.0) || !(entityplayer instanceof EntityPlayerMP)) continue;
                PacketMetallurgyExplosion packet = new PacketMetallurgyExplosion(x, y, z, (Vec3d)explosion.field_77288_k.get(entityplayer), explosion.func_180343_e(), type);
                PacketManager.network.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        }
        return explosion;
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double x = this.field_77284_b;
                    double y = this.field_77285_c;
                    double z = this.field_77282_d;
                    for (float actualSize = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); actualSize > 0.0f; actualSize -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(x, y, z);
                        IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float mitigation = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.field_77287_j, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.field_77287_j, blockpos, null, (Explosion)this);
                            actualSize -= (mitigation + 0.3f) * 0.3f;
                        }
                        if (actualSize > 0.0f) {
                            set.add(blockpos);
                        }
                        x += d0 * (double)0.3f;
                        y += d1 * (double)0.3f;
                        z += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        float sizeX2 = this.field_77280_f * 2.0f;
        int xLo = MathHelper.func_76128_c((double)(this.field_77284_b - (double)sizeX2 - 1.0));
        int xHi = MathHelper.func_76128_c((double)(this.field_77284_b + (double)sizeX2 + 1.0));
        int yLo = MathHelper.func_76128_c((double)(this.field_77285_c - (double)sizeX2 - 1.0));
        int yHi = MathHelper.func_76128_c((double)(this.field_77285_c + (double)sizeX2 + 1.0));
        int zLo = MathHelper.func_76128_c((double)(this.field_77282_d - (double)sizeX2 - 1.0));
        int zHi = MathHelper.func_76128_c((double)(this.field_77282_d + (double)sizeX2 + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)xLo, (double)yLo, (double)zLo, (double)xHi, (double)yHi, (double)zHi));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)list, (double)sizeX2);
        for (Entity entity : list) {
            EntityPlayer entityplayer;
            float sizeBasedDamage;
            double dz;
            double dyEyes;
            double dx;
            double distanceEyes;
            double distance;
            if (entity.func_180427_aV() || !((distance = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)sizeX2) <= 1.0) || (distanceEyes = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - this.field_77284_b) * dx + (dyEyes = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * dyEyes + (dz = entity.field_70161_v - this.field_77282_d) * dz))) == 0.0) continue;
            dx /= distanceEyes;
            dyEyes /= distanceEyes;
            dz /= distanceEyes;
            double blockDensity = this.field_77287_j.func_72842_a(this.getPosition(), entity.func_174813_aQ());
            double d10 = (1.0 - distance) * blockDensity;
            switch (this.type) {
                case VULCANITE: {
                    sizeBasedDamage = (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)this.field_77280_f + 1.0);
                    break;
                }
                default: {
                    sizeBasedDamage = (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)sizeX2 + 1.0);
                }
            }
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), sizeBasedDamage);
            double reducedExplosionDamage = d10;
            if (entity instanceof EntityLivingBase) {
                reducedExplosionDamage = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += dx * reducedExplosionDamage;
            entity.field_70181_x += dyEyes * reducedExplosionDamage;
            entity.field_70179_y += dz * reducedExplosionDamage;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(entityplayer, new Vec3d(dx * d10, dyEyes * d10, dz * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.field_77287_j.func_184148_a(null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.field_77280_f >= 2.0f && this.field_82755_b) {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.field_82755_b) {
            block3: for (BlockPos blockpos : this.field_77281_g) {
                IBlockState state = this.field_77287_j.func_180495_p(blockpos);
                Block block = state.func_177230_c();
                if (this.field_77287_j.field_72995_K && spawnParticles) {
                    double randX = (float)blockpos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
                    double randY = (float)blockpos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
                    double randZ = (float)blockpos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
                    double dx = randX - this.field_77284_b;
                    double dy = randY - this.field_77285_c;
                    double dz = randZ - this.field_77282_d;
                    double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                    dx /= distance;
                    dy /= distance;
                    dz /= distance;
                    double d7 = 0.5 / (distance / (double)this.field_77280_f + 0.1);
                    dx *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f));
                    dy *= d7;
                    dz *= d7;
                    float[] color = new float[3];
                    if (this.type == ExplosiveType.VULCANITE) {
                        Utils.getRGBComponents(ModMetals.VULCANITE.getStats().getColorHex(), color);
                        if (this.field_77290_i.nextInt(3) == 0) {
                            this.field_77287_j.func_175688_a(EnumParticleTypes.FLAME, (randX + this.field_77284_b) / 2.0, (randY + this.field_77285_c) / 2.0, (randZ + this.field_77282_d) / 2.0, dx, dy, dz, new int[0]);
                        } else {
                            ClientProxy.clientSpawnParticle(this.field_77287_j, randX, randY, randZ, dx, dy, dz, 3.0f, color[0], color[1], color[2], true, this.field_77290_i.nextInt(2) + 6);
                        }
                    }
                }
                if (state.func_185904_a() == Material.field_151579_a) continue;
                switch (this.type) {
                    case VULCANITE: {
                        if (block.getHarvestLevel(state) > ModMetals.VULCANITE.getStats().getToolStats().getHarvestLevel()) continue block3;
                        block.func_180653_a(this.field_77287_j, blockpos, this.field_77287_j.func_180495_p(blockpos), 1.0f, 0);
                        block.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
                        continue block3;
                    }
                }
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.field_77287_j, blockpos, this.field_77287_j.func_180495_p(blockpos), 1.0f / this.field_77280_f, 0);
                }
                block.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
            }
        }
        if (this.field_77286_a) {
            for (BlockPos pos : this.field_77281_g) {
                if (this.field_77287_j.func_180495_p(pos).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(pos.func_177977_b()).func_185913_b()) continue;
                this.field_77287_j.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }
}

