/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.world;

import com.google.common.collect.ImmutableSet;
import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.block.BlockOre;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.config.WorldGenerationConfig;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.world.WorldTickHandler;
import it.hurts.metallurgy_reforged.world.spawn.BaseOreSpawn;
import it.hurts.metallurgy_reforged.world.spawn.HighChanceTemperatureSpawn;
import it.hurts.metallurgy_reforged.world.spawn.HighChanceYLevelSpawn;
import it.hurts.metallurgy_reforged.world.spawn.IOreSpawn;
import it.hurts.metallurgy_reforged.world.spawn.NearFortressSpawn;
import it.hurts.metallurgy_reforged.world.spawn.NetherOreSpawn;
import it.hurts.metallurgy_reforged.world.spawn.SmallIslandsSpawn;
import it.hurts.metallurgy_reforged.world.spawn.VeinNextToBlockSpawn;
import java.util.ArrayDeque;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class ModWorldGen
implements IWorldGenerator {
    private static final Block DEFAULT_WORLD_BLOCK = Blocks.field_150348_b;
    public static final Block DEFAULT_END_BLOCK = Blocks.field_150377_bs;
    public static final int COMMON = WorldGenerationConfig.rarity.commonRarity;
    private static final int UNCOMMON = WorldGenerationConfig.rarity.uncommonRarity;
    private static final int RARE = WorldGenerationConfig.rarity.rareRarity;
    private static final int VERY_RARE = WorldGenerationConfig.rarity.veryRareRarity;
    private static final int ULTRA_RARE = WorldGenerationConfig.rarity.ultraRareRarity;
    private static final String RETROGEN_NAME = "MetallurgyOreGeneration";
    public static final ModWorldGen INSTANCE = new ModWorldGen();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!newGen && !WorldGenerationConfig.retrogen) {
            return;
        }
        if (world.field_73011_w.func_76569_d()) {
            this.generateOverworld(random, chunkX, chunkZ, world);
        } else if (world.field_73011_w.func_177495_o()) {
            this.generateNether(random, chunkX, chunkZ, world);
        } else {
            this.generateEnd(random, chunkX, chunkZ, world);
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    private void generateOverworld(Random random, int chunkX, int chunkZ, World world) {
        this.generateOre(ModMetals.COPPER, world, random, chunkX, chunkZ, WorldGenerationConfig.copper.veinSize, COMMON, WorldGenerationConfig.copper.minY, WorldGenerationConfig.copper.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.copper.biomes);
        this.generateOre(ModMetals.DEEP_IRON, world, random, chunkX, chunkZ, WorldGenerationConfig.deepIron.veinSize, COMMON, WorldGenerationConfig.deepIron.minY, WorldGenerationConfig.deepIron.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.deepIron.biomes);
        this.generateOre(ModMetals.TIN, world, random, chunkX, chunkZ, WorldGenerationConfig.tin.veinSize, COMMON, WorldGenerationConfig.tin.minY, WorldGenerationConfig.tin.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.tin.biomes);
        this.generateOre(ModMetals.PROMETHEUM, world, random, chunkX, chunkZ, WorldGenerationConfig.prometheum.veinSize, COMMON, WorldGenerationConfig.prometheum.minY, WorldGenerationConfig.prometheum.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.prometheum.biomes);
        this.generateOre(ModMetals.MANGANESE, world, random, chunkX, chunkZ, WorldGenerationConfig.manganese.veinSize, COMMON, WorldGenerationConfig.manganese.minY, WorldGenerationConfig.manganese.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.manganese.biomes);
        this.generateOre(ModMetals.OURECLASE, world, random, chunkX, chunkZ, WorldGenerationConfig.oureclase.veinSize, UNCOMMON, WorldGenerationConfig.oureclase.minY, WorldGenerationConfig.oureclase.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.oureclase.biomes);
        this.generateOre(ModMetals.INFUSCOLIUM, world, random, chunkX, chunkZ, WorldGenerationConfig.infuscolium.veinSize, UNCOMMON, WorldGenerationConfig.infuscolium.minY, WorldGenerationConfig.infuscolium.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.infuscolium.biomes);
        this.generateOre(ModMetals.ADAMANTINE, world, random, chunkX, chunkZ, WorldGenerationConfig.adamantine.veinSize, VERY_RARE, WorldGenerationConfig.adamantine.minY, WorldGenerationConfig.adamantine.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.adamantine.biomes);
        this.generateOre(ModMetals.RUBRACIUM, world, random, chunkX, chunkZ, WorldGenerationConfig.rubracium.veinSize, UNCOMMON, WorldGenerationConfig.rubracium.minY, WorldGenerationConfig.rubracium.maxY, (IOreSpawn)new VeinNextToBlockSpawn(DEFAULT_WORLD_BLOCK, WorldGenerationConfig.rubracium.biomes, (Set<Block>)ImmutableSet.of((Object)Blocks.field_150353_l, (Object)((Object)ModMetals.RUBRACIUM.getOre()))));
        this.generateOre(ModMetals.ATLARUS, world, random, chunkX, chunkZ, WorldGenerationConfig.atlarus.veinSize, VERY_RARE, WorldGenerationConfig.atlarus.minY, WorldGenerationConfig.atlarus.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.atlarus.biomes);
        this.generateOre(ModMetals.CARMOT, world, random, chunkX, chunkZ, WorldGenerationConfig.carmot.veinSize, RARE, WorldGenerationConfig.carmot.minY, WorldGenerationConfig.carmot.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.carmot.biomes);
        this.generateOre(ModMetals.MITHRIL, world, random, chunkX, chunkZ, WorldGenerationConfig.mithril.veinSize, ULTRA_RARE, WorldGenerationConfig.mithril.minY, WorldGenerationConfig.mithril.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.mithril.biomes);
        this.generateOre(ModMetals.ZINC, world, random, chunkX, chunkZ, WorldGenerationConfig.zinc.veinSize, COMMON, WorldGenerationConfig.zinc.minY, WorldGenerationConfig.zinc.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.zinc.biomes);
        this.generateOre(ModMetals.ORICHALCUM, world, random, chunkX, chunkZ, WorldGenerationConfig.orichalcum.veinSize, RARE, WorldGenerationConfig.orichalcum.minY, WorldGenerationConfig.orichalcum.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.orichalcum.biomes);
        this.generateOre(ModMetals.ASTRAL_SILVER, world, random, chunkX, chunkZ, WorldGenerationConfig.astralSilver.veinSize, UNCOMMON, WorldGenerationConfig.astralSilver.minY, WorldGenerationConfig.astralSilver.maxY, (IOreSpawn)new HighChanceYLevelSpawn(DEFAULT_WORLD_BLOCK, WorldGenerationConfig.astralSilver.biomes, 80, true, 0.5f));
        this.generateOre(ModMetals.SILVER, world, random, chunkX, chunkZ, WorldGenerationConfig.silver.veinSize, UNCOMMON, WorldGenerationConfig.silver.minY, WorldGenerationConfig.silver.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.silver.biomes);
        this.generateOre(ModMetals.PLATINUM, world, random, chunkX, chunkZ, WorldGenerationConfig.platinum.veinSize, VERY_RARE, WorldGenerationConfig.platinum.minY, WorldGenerationConfig.platinum.maxY, (IOreSpawn)new HighChanceTemperatureSpawn(DEFAULT_WORLD_BLOCK, WorldGenerationConfig.platinum.biomes, Biome.TempCategory.WARM, UNCOMMON));
        this.generateOre(ModMetals.OSMIUM, world, random, chunkX, chunkZ, WorldGenerationConfig.osmium.veinSize, UNCOMMON, WorldGenerationConfig.osmium.minY, WorldGenerationConfig.osmium.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.osmium.biomes);
        this.generateOre(ModBlocks.oreSulfur, world, random, chunkX, chunkZ, WorldGenerationConfig.sulfur.veinSize, UNCOMMON, WorldGenerationConfig.sulfur.minY, WorldGenerationConfig.sulfur.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.sulfur.biomes);
        this.generateOre(ModBlocks.orePhosphorite, world, random, chunkX, chunkZ, WorldGenerationConfig.phosphorite.veinSize, UNCOMMON, WorldGenerationConfig.phosphorite.minY, WorldGenerationConfig.phosphorite.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.phosphorite.biomes);
        this.generateOre(ModBlocks.orePotash, world, random, chunkX, chunkZ, WorldGenerationConfig.potash.veinSize, COMMON, WorldGenerationConfig.potash.minY, WorldGenerationConfig.potash.maxY, DEFAULT_WORLD_BLOCK, WorldGenerationConfig.potash.biomes);
    }

    private void generateNether(Random random, int chunkX, int chunkZ, World world) {
        this.generateOre(ModMetals.IGNATIUS, world, random, chunkX, chunkZ, WorldGenerationConfig.ignatius.veinSize, COMMON, WorldGenerationConfig.ignatius.minY, WorldGenerationConfig.ignatius.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.ignatius.biomes));
        this.generateOre(ModMetals.SHADOW_IRON, world, random, chunkX, chunkZ, WorldGenerationConfig.shadowIron.veinSize, COMMON, WorldGenerationConfig.shadowIron.minY, WorldGenerationConfig.shadowIron.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.shadowIron.biomes));
        this.generateOre(ModMetals.LEMURITE, world, random, chunkX, chunkZ, WorldGenerationConfig.lemurite.veinSize, COMMON, WorldGenerationConfig.lemurite.minY, WorldGenerationConfig.lemurite.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.lemurite.biomes));
        this.generateOre(ModMetals.LUTETIUM, world, random, chunkX, chunkZ, WorldGenerationConfig.lutetium.veinSize, VERY_RARE, WorldGenerationConfig.lutetium.minY, WorldGenerationConfig.lutetium.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.lutetium.biomes));
        this.generateOre(ModMetals.MIDASIUM, world, random, chunkX, chunkZ, WorldGenerationConfig.midasium.veinSize, UNCOMMON, WorldGenerationConfig.midasium.minY, WorldGenerationConfig.midasium.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.midasium.biomes));
        this.generateOre(ModMetals.VYROXERES, world, random, chunkX, chunkZ, WorldGenerationConfig.vyroxeres.veinSize, UNCOMMON, WorldGenerationConfig.vyroxeres.minY, WorldGenerationConfig.vyroxeres.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.vyroxeres.biomes));
        this.generateOre(ModMetals.CERUCLASE, world, random, chunkX, chunkZ, WorldGenerationConfig.cerucalse.veinSize, VERY_RARE, WorldGenerationConfig.cerucalse.minY, WorldGenerationConfig.cerucalse.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.cerucalse.biomes));
        this.generateOre(ModMetals.ALDUORITE, world, random, chunkX, chunkZ, WorldGenerationConfig.alduorite.veinSize, UNCOMMON, WorldGenerationConfig.alduorite.minY, WorldGenerationConfig.alduorite.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.alduorite.biomes));
        this.generateOre(ModMetals.KALENDRITE, world, random, chunkX, chunkZ, WorldGenerationConfig.kalendrite.veinSize, RARE, WorldGenerationConfig.kalendrite.minY, WorldGenerationConfig.kalendrite.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.kalendrite.biomes));
        this.generateOre(ModMetals.VULCANITE, world, random, chunkX, chunkZ, WorldGenerationConfig.vulcanite.veinSize, UNCOMMON, WorldGenerationConfig.vulcanite.minY, WorldGenerationConfig.vulcanite.maxY, (IOreSpawn)new NetherOreSpawn(WorldGenerationConfig.vulcanite.biomes));
        this.generateOre(ModMetals.SANGUINITE, world, random, chunkX, chunkZ, WorldGenerationConfig.sanguinite.veinSize, VERY_RARE, WorldGenerationConfig.sanguinite.minY, WorldGenerationConfig.sanguinite.maxY, (IOreSpawn)new NearFortressSpawn());
    }

    private void generateEnd(Random random, int chunkX, int chunkZ, World world) {
        this.generateOre(ModMetals.EXIMITE, world, random, chunkX, chunkZ, WorldGenerationConfig.eximite.veinSize, COMMON, WorldGenerationConfig.eximite.minY, WorldGenerationConfig.eximite.maxY, (IOreSpawn)new SmallIslandsSpawn(WorldGenerationConfig.eximite.biomes));
        this.generateOre(ModMetals.MEUTOITE, world, random, chunkX, chunkZ, WorldGenerationConfig.meutoite.veinSize, RARE, WorldGenerationConfig.meutoite.minY, WorldGenerationConfig.meutoite.maxY, DEFAULT_END_BLOCK, WorldGenerationConfig.meutoite.biomes);
    }

    private void generateOre(Metal metal, World world, Random random, int chunkX, int chunkZ, int veinSize, int rarity, int minY, int maxY, Block blockToReplace, String[] biomesResource) {
        this.generateOre(metal, world, random, chunkX, chunkZ, veinSize, rarity, minY, maxY, (IOreSpawn)new BaseOreSpawn(blockToReplace, biomesResource));
    }

    private void generateOre(Metal metal, World world, Random random, int chunkX, int chunkZ, int veinSize, int rarity, int minY, int maxY, IOreSpawn oreSpawn) {
        if (metal == null) {
            return;
        }
        this.generateOre(metal.getOre(), world, random, chunkX, chunkZ, veinSize, rarity, minY, maxY, oreSpawn);
    }

    private void generateOre(BlockOre block, World world, Random random, int chunkX, int chunkZ, int veinSize, int rarity, int minY, int maxY, Block blockToReplace, String[] biomesResource) {
        this.generateOre(block, world, random, chunkX, chunkZ, veinSize, rarity, minY, maxY, (IOreSpawn)new BaseOreSpawn(blockToReplace, biomesResource));
    }

    private void generateOre(BlockOre block, World world, Random random, int chunkX, int chunkZ, int veinSize, int rarity, int minY, int maxY, IOreSpawn oreSpawn) {
        int heightLimit = world.field_73011_w.getActualHeight();
        if (minY < 0 || maxY > heightLimit) {
            Metallurgy.logger.error("Illegal Height Arguments on Ore Generator for ore: " + block.getRegistryName().func_110623_a() + " | minY: " + minY + " | maxY: " + maxY);
            return;
        }
        if (veinSize > 0) {
            WorldGenMinable generator = new WorldGenMinable(block.func_176223_P(), Math.max(veinSize, 3), oreSpawn.getBlockPredicate());
            int heightdiff = maxY - minY + 1;
            int oreSpawnRarity = oreSpawn.getRarity(world.func_72964_e(chunkX, chunkZ), rarity);
            for (int i = 0; i < oreSpawnRarity; ++i) {
                int x = chunkX * 16 + random.nextInt(16);
                int y = heightdiff >= 0 ? minY + random.nextInt(heightdiff) : (random.nextBoolean() ? heightLimit - random.nextInt(heightLimit - minY) : 1 + random.nextInt(maxY));
                int z = chunkZ * 16 + random.nextInt(16);
                BlockPos pos = new BlockPos(x, y, z);
                if (!oreSpawn.canOreSpawn(world.func_72964_e(chunkX, chunkZ), pos, world.func_180495_p(pos), random)) continue;
                generator.func_180709_b(world, random, pos);
            }
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        NBTTagCompound genTag = event.getData().func_74775_l(RETROGEN_NAME);
        if (!genTag.func_74764_b("generated")) {
            genTag.func_74757_a("generated", true);
        }
        event.getData().func_74782_a(RETROGEN_NAME, (NBTBase)genTag);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a(RETROGEN_NAME);
        ChunkPos coordinates = event.getChunk().func_76632_l();
        if (tag != null) {
            boolean generated = false;
            if (generated) {
                if (WorldGenerationConfig.verbose_retrogen) {
                    Metallurgy.logger.log(Level.INFO, "Queuing retrogen for chunk: " + coordinates.toString() + ".");
                }
                regen = true;
            }
        } else {
            regen = WorldGenerationConfig.retrogen;
        }
        if (regen) {
            ArrayDeque chunks = (ArrayDeque)WorldTickHandler.chunksToGenerate.get(dimension);
            if (chunks == null) {
                WorldTickHandler.chunksToGenerate.put(dimension, new ArrayDeque(128));
                chunks = (ArrayDeque)WorldTickHandler.chunksToGenerate.get(dimension);
            }
            if (chunks != null) {
                chunks.addLast(coordinates);
                WorldTickHandler.chunksToGenerate.put(dimension, (Object)chunks);
            }
        }
    }
}

