/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import com.google.common.collect.Sets;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class WorldUtils {
    public static Set<BlockPos> getAllColliding(Vec3d start, Vec3d target) {
        LinkedHashSet list = Sets.newLinkedHashSet();
        Vec3d directionVec = target.func_178788_d(start);
        double length = directionVec.func_72433_c();
        double xBit = directionVec.field_72450_a / (10.0 * length);
        double yBit = directionVec.field_72448_b / (10.0 * length);
        double zBit = directionVec.field_72449_c / (10.0 * length);
        int i = 1;
        while ((double)i <= length * 10.0) {
            double x = start.field_72450_a + xBit * (double)i;
            double y = start.field_72448_b + yBit * (double)i;
            double z = start.field_72449_c + zBit * (double)i;
            list.add(new BlockPos(x, y, z));
            ++i;
        }
        return list;
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block ... blocks) {
        return WorldUtils.getBlocksWithinRadius(pos, xradius, yradius, zradius, blockPos -> ArrayUtils.contains((Object[])blocks, (Object)world.func_180495_p(blockPos)));
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block block) {
        return WorldUtils.getBlocksWithinRadius(pos, xradius, yradius, zradius, test -> world.func_180495_p(test).func_177230_c() == block);
    }

    public static List<BlockPos> getBlocksWithinRadius(BlockPos pos, float xradius, float yradius, float zradius, Predicate<BlockPos> comparison) {
        ArrayList<BlockPos> blockList = new ArrayList<BlockPos>();
        int x = (int)(-xradius);
        while ((float)x <= xradius) {
            int z = (int)(-zradius);
            while ((float)z <= zradius) {
                int y = (int)(-yradius);
                while ((float)y <= yradius) {
                    if (comparison.test(pos.func_177982_a(x, y, z))) {
                        blockList.add(pos.func_177982_a(x, y, z));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return blockList;
    }

    public static Optional<BlockPos> getRandomBlockWithinRadius(int attempts, BlockPos center, int xradius, int yradius, int zradius, Predicate<BlockPos> validator) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = center.func_177958_n() - xradius + Utils.random.nextInt(xradius * 2 + 1);
            BlockPos pos = new BlockPos(x, y = center.func_177956_o() - yradius + Utils.random.nextInt(yradius * 2 + 1), z = center.func_177952_p() - zradius + Utils.random.nextInt(zradius * 2 + 1));
            if (!validator.test(pos)) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }
}

