/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.hurts.metallurgy_reforged.Metallurgy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Utils {
    public static Random random = new Random();
    private static final Potion[] randomEffectsList = new Potion[]{MobEffects.field_76440_q, MobEffects.field_188424_y, MobEffects.field_76438_s, MobEffects.field_76433_i, MobEffects.field_76431_k, MobEffects.field_76439_r, MobEffects.field_76436_u, MobEffects.field_76421_d, MobEffects.field_76428_l};
    @Deprecated
    private static final Map<TextFormatting, Integer> minecraftColors = new HashMap<TextFormatting, Integer>();

    public static void giveExperience(EntityPlayer player, float experience) {
        int intExp = (int)experience;
        float fractional = experience - (float)intExp;
        if (fractional > 0.0f && (float)Math.random() < fractional) {
            ++intExp;
        }
        while (intExp > 0) {
            int j = EntityXPOrb.func_70527_a((int)intExp);
            intExp -= j;
            player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, j));
        }
    }

    public static double angle(Vec3d first, Vec3d second) {
        double dot = first.func_72430_b(second);
        double lengthProd = first.func_72433_c() * second.func_72433_c();
        return Math.acos(dot / lengthProd);
    }

    public static String localizeEscapingCustomSequences(String unlocalized) {
        String translation = new TextComponentTranslation(unlocalized, new Object[0]).func_150254_d();
        translation = translation.replace("<PC>", "%").replace("<NL>", "\n");
        return translation;
    }

    public static String localizeWithParameters(String unlocalized, Object ... params) {
        return new TextComponentTranslation(unlocalized, params).func_150254_d();
    }

    public static String localizeIgnoreFormat(String unlocalized) {
        return new TextComponentTranslation(unlocalized, new Object[0]).func_150261_e();
    }

    public static Potion getRandomEffect() {
        return randomEffectsList[(int)(Math.random() * (double)Utils.getMaxIndexEffect())];
    }

    private static int getMaxIndexEffect() {
        return randomEffectsList.length;
    }

    @Deprecated
    public static int intColorFromRGB(int r, int g, int b) {
        return -16777216 + r * 65536 + g * 256 + b;
    }

    public static float[] getRGBComponents(int hex, @Nullable float[] results) {
        int red = hex >> 16 & 0xFF;
        int green = hex >> 8 & 0xFF;
        int blue = hex & 0xFF;
        float[] array = results != null ? results : new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
        return array;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 1.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 1.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 1.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 1.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static CraftingHelper.ShapedPrimer parseShapedRecipe(JsonContext context, JsonObject json) {
        HashMap ingredientMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingredientMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ingredientMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingredientMap.keySet());
        keys.remove(Character.valueOf(' '));
        int index = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingredientMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(index++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        return primer;
    }

    public static String capitalize(String string) {
        char uppercased = Character.toUpperCase(string.charAt(0));
        return string.replace(string.charAt(0), uppercased);
    }

    public static Path getPath(String resource) {
        block6: {
            try {
                Path path;
                URL url = Metallurgy.class.getResource(resource);
                if (url == null) break block6;
                URI uri = url.toURI();
                if ("file".equals(uri.getScheme())) {
                    path = Paths.get(Metallurgy.class.getResource(resource).toURI());
                } else {
                    FileSystem filesystem;
                    try {
                        filesystem = FileSystems.getFileSystem(uri);
                    }
                    catch (FileSystemNotFoundException e) {
                        filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    path = filesystem.getPath(resource, new String[0]);
                }
                return path;
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean copyFile(Path originalPath, String newPath, boolean overwrite) {
        File userConfigFile = new File(newPath);
        try {
            if (!userConfigFile.exists() || overwrite) {
                Files.copy(originalPath, userConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static <T> boolean listContains(List<T> list, T item, BiPredicate<? super T, ? super T> comparator) {
        return list.stream().anyMatch(listItem -> comparator.test(listItem, item));
    }

    public static <T> T makeDo(T thing, Consumer<T> todo) {
        todo.accept(thing);
        return thing;
    }

    static {
        minecraftColors.put(TextFormatting.BLACK, 0);
        minecraftColors.put(TextFormatting.DARK_BLUE, 170);
        minecraftColors.put(TextFormatting.DARK_GREEN, 43520);
        minecraftColors.put(TextFormatting.DARK_AQUA, 43690);
        minecraftColors.put(TextFormatting.DARK_RED, 0xAA0000);
        minecraftColors.put(TextFormatting.DARK_PURPLE, 0xAA00AA);
        minecraftColors.put(TextFormatting.GOLD, 0xFFAA00);
        minecraftColors.put(TextFormatting.DARK_GRAY, 0x555555);
        minecraftColors.put(TextFormatting.BLUE, 0x5555FF);
        minecraftColors.put(TextFormatting.GREEN, 0x55FF55);
        minecraftColors.put(TextFormatting.AQUA, 0x55FFFF);
        minecraftColors.put(TextFormatting.RED, 0xFF5555);
        minecraftColors.put(TextFormatting.LIGHT_PURPLE, 0xFF55FF);
        minecraftColors.put(TextFormatting.YELLOW, 0xFFFF55);
        minecraftColors.put(TextFormatting.WHITE, 0xFFFFFF);
    }
}

