/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.IMetalItem;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.material.ToolStats;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class ItemUtils {
    public static void initItem(Item item, String name, CreativeTabs tab) {
        item.func_77655_b("metallurgy." + name);
        item.setRegistryName("metallurgy", name);
        item.func_77637_a(tab);
    }

    public static boolean isItemStackASpecificToolMaterial(Metal metal, ItemStack toolStack, String ... except) {
        Item item = toolStack.func_77973_b();
        if (!toolStack.func_190926_b() && item instanceof ItemTool) {
            ItemTool tool = (ItemTool)toolStack.func_77973_b();
            boolean valid = tool.func_77861_e().equalsIgnoreCase(metal.getToolMaterial().name());
            for (String type : except) {
                String toolName = metal.getStats().getName() + "_" + type;
                if (!tool.func_77658_a().equalsIgnoreCase(toolName)) continue;
                valid = false;
            }
            return valid;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void buildEffectTooltip(List<String> tooltip, Set<BaseMetallurgyEffect> effects, ItemStack stack, @Nullable EnumTools toolType) {
        if (!effects.isEmpty()) {
            boolean anyEnabled = false;
            for (BaseMetallurgyEffect effect2 : effects) {
                if (!effect2.isEnabled()) continue;
                tooltip.add((String)effect2.getTooltip().getLeft());
                if (Keyboard.isKeyDown((int)29)) {
                    tooltip.add((String)effect2.getTooltip().getRight());
                }
                anyEnabled = true;
            }
            Metal paragon = TartariteEffect.getParagonMetal(stack);
            if (paragon != null) {
                MetallurgyEffects.effects.row((Object)paragon).forEach((category, effect) -> {
                    boolean allEffect = category == EnumEffectCategory.ALL;
                    boolean armorEffect = category == EnumEffectCategory.ARMOR && toolType == null;
                    boolean toolEffect = ArrayUtils.contains((Object[])category.getTools(), (Object)((Object)toolType));
                    if (allEffect || armorEffect || toolEffect) {
                        tooltip.add((String)effect.getTooltip().getLeft());
                        if (Keyboard.isKeyDown((int)29)) {
                            tooltip.add((String)effect.getTooltip().getRight());
                        }
                    }
                });
            }
            if (anyEnabled && !Keyboard.isKeyDown((int)29)) {
                tooltip.add(Utils.localizeEscapingCustomSequences("tooltip.metallurgy.press_ctrl"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void buildStatsTooltip(List<String> tooltip, EnumTools toolType, ToolStats stats, ItemStack toolStack) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Utils.localizeEscapingCustomSequences("tooltip.metallurgy.press_shift"));
        } else {
            int maxDurability;
            float useRatio;
            if (toolType == EnumTools.PICKAXE) {
                int harvest = MathHelper.func_76125_a((int)stats.getHarvestLevel(), (int)1, (int)7);
                ScaleFormatting harvestFormatting = ScaleFormatting.values()[harvest - 1];
                tooltip.add(Utils.localizeWithParameters("tooltip.metallurgy.stats.harvest_level", harvestFormatting.format + harvestFormatting.stars));
            }
            TextFormatting useColor = (useRatio = (float)((maxDurability = toolStack.func_77958_k()) - toolStack.func_77952_i()) / (float)maxDurability) < 0.33f ? TextFormatting.RED : ((double)useRatio < 0.66 ? TextFormatting.YELLOW : TextFormatting.GREEN);
            tooltip.add(Utils.localizeWithParameters("tooltip.metallurgy.stats.durability", useColor + String.valueOf(toolStack.func_77958_k() - toolStack.func_77952_i()) + '/' + maxDurability));
            if (toolType == EnumTools.PICKAXE || toolType == EnumTools.AXE || toolType == EnumTools.SHOVEL) {
                float efficiency = stats.getEfficiency();
                int formattingIndex = MathHelper.func_76123_f((float)MathHelper.func_76131_a((float)(efficiency - 6.0f), (float)0.0f, (float)6.0f));
                ScaleFormatting efficiencyFormatting = ScaleFormatting.values()[formattingIndex];
                tooltip.add(Utils.localizeWithParameters("tooltip.metallurgy.stats.efficiency", efficiencyFormatting.format + String.valueOf(efficiency)));
            }
        }
    }

    public static boolean equalsWildcard(ItemStack wild, ItemStack check) {
        if (wild.func_190926_b() || check.func_190926_b()) {
            return check.equals(wild);
        }
        return wild.func_77973_b() == check.func_77973_b() && (wild.func_77952_i() == Short.MAX_VALUE || check.func_77952_i() == Short.MAX_VALUE || wild.func_77952_i() == check.func_77952_i());
    }

    public static void editInventoryStackSize(NonNullList<ItemStack> inventory, int slot, int amount) {
        if (slot >= 0 && slot < inventory.size() && !((ItemStack)inventory.get(slot)).func_190926_b()) {
            ((ItemStack)inventory.get(slot)).func_190917_f(amount);
            if (((ItemStack)inventory.get(slot)).func_190916_E() <= 0) {
                inventory.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static boolean isItemStackSpecificArmorMaterial(Metal metal, ItemStack armor) {
        return !armor.func_190926_b() && armor.func_77973_b() instanceof ItemArmorBase && ((ItemArmorBase)armor.func_77973_b()).func_82812_d().func_179242_c().equalsIgnoreCase(metal.getArmorMaterial().func_179242_c());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerCustomItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerCustomItemModel(Item item, int meta, String subdir) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("metallurgy:" + subdir + (!subdir.equals("") ? "/" : "") + item.getRegistryName().func_110623_a(), "inventory"));
    }

    @SafeVarargs
    public static boolean isMadeOfMetal(Metal metal, @Nonnull Item item, Class<? extends IMetalItem> ... filters) {
        MetalStats itemStats;
        if (item instanceof IMetalItem && (itemStats = ((IMetalItem)item).getMetalStats()) != null) {
            if (itemStats.getName().equals(metal.toString())) {
                if (filters.length == 0) {
                    return true;
                }
                for (Class<? extends IMetalItem> clazz : filters) {
                    if (!clazz.isInstance(item)) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Nullable
    public static Metal getMetalFromItem(Item item) {
        MetalStats metalStats;
        if (item instanceof IMetalItem && (metalStats = ((IMetalItem)item).getMetalStats()) != null) {
            return ModMetals.metalMap.get(metalStats.getName());
        }
        if (item instanceof ItemBlock) {
            return BlockUtils.getMetalFromBlock(((ItemBlock)item).func_179223_d());
        }
        return null;
    }

    public static void editOrAddModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double amount) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            AttributeModifier newMod = new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() + amount, modifier.func_111169_c());
            modifiers.add(newMod);
        } else {
            modifiers.add(new AttributeModifier(id, "Metallurgy Modifier " + Math.ceil(Math.random() * 1000.0), amount, 0));
        }
    }

    public static void setToolAttributes(@Nonnull EntityEquipmentSlot equipmentSlot, Multimap<String, AttributeModifier> multimap, MetalStats metalStats) {
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            ToolStats toolStats = metalStats.getToolStats();
            if (toolStats.getMaxHealth() != 0.0) {
                multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.MAX_HEALTH, "Metallurgy Tool Max Health", toolStats.getMaxHealth(), 0));
            }
            if (toolStats.getMovementSpeed() != 0.0) {
                multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.MOVEMENT_SPEED, "Metallurgy Tool Movement Speed", toolStats.getMovementSpeed(), 0));
            }
            if (toolStats.getAttackDamageAttribute() != 0.0) {
                ItemUtils.editOrAddModifier(multimap, SharedMonsterAttributes.field_111264_e, Constants.ModAttributes.ATTACK_DAMAGE, toolStats.getAttackDamageAttribute());
            }
            if (toolStats.getAttackSpeed() != 0.0) {
                ItemUtils.editOrAddModifier(multimap, SharedMonsterAttributes.field_188790_f, Constants.ModAttributes.ATTACK_SPEED, toolStats.getAttackSpeed());
            }
            if (toolStats.getReachDistance() != 0.0) {
                multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.REACH_DISTANCE, "Metallurgy Tool Reach Distance", toolStats.getReachDistance(), 0));
            }
        }
    }

    public static Metal getMetalFromOreDictStack(ItemStack stack) {
        int[] ids;
        if (stack.func_190926_b()) {
            return null;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String ore = OreDictionary.getOreName((int)id);
            String snakeOre = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ore);
            Object[] snakeArray = snakeOre.split("_");
            String metalName = String.join((CharSequence)"_", (CharSequence[])ArrayUtils.removeElement((Object[])snakeArray, (Object)snakeArray[0]));
            if (!ModMetals.metalMap.containsKey(metalName)) continue;
            return ModMetals.metalMap.get(metalName);
        }
        return null;
    }

    public static void removeEnchantment(Enchantment enchantment, ItemStack item) {
        int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)item);
        if (enchLevel > 0) {
            Iterator enchantIter = item.func_77986_q().iterator();
            while (enchantIter.hasNext()) {
                if (Enchantment.func_185262_c((int)((NBTTagCompound)enchantIter.next()).func_74765_d("id")) != enchantment) continue;
                enchantIter.remove();
            }
        }
    }

    public static List<ItemStack> compactStackList(List<ItemStack> itemStackList) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(itemStackList.size());
        itemStackList.forEach(stack -> {
            boolean wasFound = false;
            for (ItemStack cachedStack : newList) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)cachedStack)) continue;
                cachedStack.func_190920_e(cachedStack.func_190916_E() + stack.func_190916_E());
                if (cachedStack.func_77978_p() != null && stack.func_77978_p() != null) {
                    cachedStack.func_77978_p().func_179237_a(stack.func_77978_p());
                } else if (stack.func_77978_p() != null) {
                    cachedStack.func_77982_d(stack.func_77978_p());
                }
                wasFound = true;
                break;
            }
            if (!wasFound) {
                newList.add((ItemStack)stack);
            }
        });
        return newList;
    }

    public static enum ScaleFormatting {
        _1("\u2b51", TextFormatting.DARK_RED),
        _2("\u2b51\u2b51", TextFormatting.RED),
        _3("\u2b51\u2b51\u2b51", TextFormatting.GOLD),
        _4("\u2b51\u2b51\u2b51\u2b51", TextFormatting.YELLOW),
        _5("\u2b51\u2b51\u2b51\u2b51\u2b51", TextFormatting.DARK_GREEN),
        _6("\u2b51\u2b51\u2b51\u2b51\u2b51\u2b51", TextFormatting.AQUA),
        _7("\u2b51\u2b51\u2b51\u2b51\u2b51\u2b51\u2b51", TextFormatting.LIGHT_PURPLE);

        final String stars;
        public final TextFormatting format;

        private ScaleFormatting(String stars, TextFormatting format) {
            this.stars = stars;
            this.format = format;
        }
    }
}

