/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ArrayList;
import jline.internal.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EventUtils {
    private static final Metal[] metal_array = (Metal[])ModMetals.metalMap.values().stream().filter(metal -> metal != null && metal.hasArmorSet() && EventUtils.canMetalBeEquippedByMob(metal)).toArray(Metal[]::new);

    public static boolean isWearingFullArmorSet(EntityLivingBase entity, Metal metal) {
        boolean fullArmored = true;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || entity.func_184582_a(slot).func_77973_b() == metal.getArmorPiece(slot)) continue;
            fullArmored = false;
        }
        return fullArmored;
    }

    public static boolean isPlayerWearingSpecificArmorPiece(EntityPlayer player, EntityEquipmentSlot slot, Item armorEquip) {
        return ((ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b())).func_77973_b() == armorEquip;
    }

    public static int getArmorPiecesCount(EntityLivingBase entity, Metal metal) {
        int count = 0;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !entity.func_184582_a(slot).func_77973_b().equals(metal.getArmorPiece(slot))) continue;
            ++count;
        }
        return count;
    }

    public static boolean canHarvest(ItemStack tool, IBlockState block) {
        EnumTools toolType = EnumTools.byInstance(tool.func_77973_b());
        String blockToolClass = block.func_177230_c().getHarvestTool(block);
        if (block.func_177230_c() == Blocks.field_150357_h) {
            return false;
        }
        if (blockToolClass == null) {
            return true;
        }
        if (toolType == null) {
            return false;
        }
        if (!blockToolClass.equals(toolType.getName())) {
            return false;
        }
        return block.func_177230_c().getHarvestLevel(block) <= tool.func_77973_b().getHarvestLevel(tool, toolType.getName(), null, block);
    }

    private static boolean canMetalBeEquippedByMob(Metal metal) {
        for (String metalString : GeneralConfig.metalsThatCannotBeEquipped) {
            if (!metal.getStats().getName().equalsIgnoreCase(metalString)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getRandomEquipmentPiece(Metal metal, EntityLivingBase entity) {
        ArrayList<ItemStack> equip = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184209_aF()) {
            if (!ItemUtils.isMadeOfMetal(metal, stack.func_77973_b(), new Class[0]) && TartariteEffect.getParagonMetal(stack) != metal) continue;
            equip.add(stack);
        }
        return (ItemStack)equip.get(Utils.random.nextInt(equip.size()));
    }

    @Nullable
    public static Metal getRandomMetalBasedOnDifficulty(World world) {
        float chance = 0.0f;
        switch (world.func_175659_aa().func_151525_a()) {
            case 0: {
                chance = 0.0f;
                break;
            }
            case 1: {
                chance = 5.0f;
                break;
            }
            case 2: {
                chance = 10.0f;
                break;
            }
            case 3: {
                chance = 15.0f;
            }
        }
        if (Utils.random.nextFloat() * 100.0f < chance) {
            return metal_array[Utils.random.nextInt(metal_array.length)];
        }
        return null;
    }

    public static double applyAttributeModifier(double base, AttributeModifier modifier) {
        switch (modifier.func_111169_c()) {
            case 0: {
                return base + modifier.func_111164_d();
            }
            case 1: {
                return base + base * modifier.func_111164_d();
            }
            case 2: {
                return base * (1.0 + modifier.func_111164_d());
            }
        }
        return base;
    }

    public static float getDarknessLevel(Entity entity, float maxClamp) {
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        boolean isDay = entity.field_70170_p.field_73011_w.isDaytime();
        int lightSky = Math.min(isDay ? entity.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos) : 0, 14);
        int lightBlock = Math.min(entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos), 14);
        int light = Math.max(lightSky, lightBlock);
        return maxClamp - (float)light * maxClamp / 14.0f;
    }
}

