/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import it.hurts.metallurgy_reforged.block.BlockMetal;
import it.hurts.metallurgy_reforged.fluid.ModFluids;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidClassic;

public class BlockUtils {
    public static void initBlock(Block block, String name, CreativeTabs tab, float hardness, float blastResistance, String toolClass, int harvestLevel) {
        block.setRegistryName("metallurgy", name);
        block.func_149663_c("metallurgy." + name);
        if (tab != null) {
            block.func_149647_a(tab);
        }
        block.func_149711_c(hardness);
        block.func_149752_b(blastResistance);
        block.setHarvestLevel(toolClass, harvestLevel);
    }

    public static void initBlock(Block block, String name, CreativeTabs tab) {
        block.setRegistryName("metallurgy", name);
        block.func_149663_c("metallurgy." + name);
        if (tab != null) {
            block.func_149647_a(tab);
        }
    }

    public static void initFluidBlock(BlockFluidClassic fluidBlock, String name) {
        fluidBlock.getFluid().setBlock((Block)fluidBlock);
        fluidBlock.setRegistryName("metallurgy", name);
        fluidBlock.func_149663_c("metallurgy." + name);
        fluidBlock.func_149647_a(MetallurgyTabs.tabFluid);
        ModFluids.fluidBlocks.add(fluidBlock);
    }

    public static Metal getMetalFromBlock(Block block) {
        if (block instanceof BlockMetal) {
            BlockMetal blockMetal = (BlockMetal)block;
            for (Map.Entry<String, Metal> entry : ModMetals.metalMap.entrySet()) {
                if (!blockMetal.getMetalStats().getName().equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static List<BlockPos> getAdjacentPosList(IBlockAccess world, BlockPos pos, Predicate<BlockPos> condition) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(6);
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (!condition.test(offsetPos)) continue;
            positions.add(offsetPos);
        }
        return positions;
    }
}

