/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.render.font;

import it.hurts.metallurgy_reforged.render.font.FontColor;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModFontRenderer
extends FontRenderer {
    private boolean dropShadow;
    private int state = 0;
    private int red;
    private int green;
    private int blue;

    public ModFontRenderer(GameSettings gameSettingsIn, ResourceLocation location, TextureManager textureManagerIn) {
        super(gameSettingsIn, location, textureManagerIn, true);
    }

    @Nonnull
    public List<String> func_78271_c(@Nonnull String str, int wrapWidth) {
        return Arrays.asList(this.func_78280_d(str, wrapWidth).split("\n"));
    }

    protected String func_78280_d(String str, int wrapWidth) {
        int i = this.func_78259_e(str, wrapWidth);
        if (str.length() <= i) {
            return str;
        }
        String s = str.substring(0, i);
        char c0 = str.charAt(i);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s1 = ModFontRenderer.getCustomFormatFromString(s) + str.substring(i + (flag ? 1 : 0));
        return s + "\n" + this.func_78280_d(s1, wrapWidth);
    }

    public static String getCustomFormatFromString(String text) {
        String s = "";
        int j = text.length();
        for (int i = 0; i < j - 1; ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                char c0 = text.charAt(i + 1);
                if (c0 >= '0' && c0 <= '9' || c0 >= 'a' && c0 <= 'f' || c0 >= 'A' && c0 <= 'F') {
                    s = "\u00a7" + c0;
                    ++i;
                    continue;
                }
                if (!(c0 >= 'k' && c0 <= 'o' || c0 >= 'K' && c0 <= 'O' || c0 == 'r') && c0 != 'R') continue;
                s = s + "\u00a7" + c0;
                ++i;
                continue;
            }
            if (c < FontColor.MARKER || c > FontColor.MARKER + 255) continue;
            s = String.format("%s%s%s", Character.valueOf(c), Character.valueOf(text.charAt(i + 1)), Character.valueOf(text.charAt(i + 2)));
            i += 2;
        }
        return s;
    }

    public int func_180455_b(@Nonnull String text, float x, float y, int color, boolean dropShadow) {
        this.dropShadow = dropShadow;
        return super.func_180455_b(text, x, y, color, dropShadow);
    }

    protected float func_78277_a(char letter, boolean italic) {
        if (letter >= FontColor.MARKER && letter <= FontColor.MARKER + 255) {
            int value = letter & 0xFF;
            switch (this.state) {
                case 0: {
                    this.red = value;
                    break;
                }
                case 1: {
                    this.green = value;
                    break;
                }
                case 2: {
                    this.blue = value;
                    break;
                }
                default: {
                    this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    return 0.0f;
                }
            }
            ++this.state;
            this.state %= 3;
            int color = this.red << 16 | this.green << 8 | this.blue | 0xFF000000;
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            if (this.dropShadow) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
            return 0.0f;
        }
        if (this.state != 0) {
            this.state = 0;
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        return super.func_78277_a(letter, italic);
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        super.func_110549_a(resourceManager);
        this.func_78264_a(Minecraft.func_71410_x().func_135016_M().func_135042_a() || Minecraft.func_71410_x().field_71474_y.field_151455_aw);
        this.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
    }
}

