/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class SublimationRecipes {
    private static final SublimationRecipes INSTANCE = new SublimationRecipes();
    private final Map<ItemStack, PotionEffect> sublimationList = new HashMap<ItemStack, PotionEffect>();

    public static SublimationRecipes getInstance() {
        return INSTANCE;
    }

    private SublimationRecipes() {
        this.addSublimationRecipe(ModMetals.ADAMANTINE, 3, new PotionEffect(MobEffects.field_180152_w, 18000, 3));
        this.addSublimationRecipe(ModMetals.AMORDRINE, 3, new PotionEffect(MobEffects.field_76430_j, 18000));
        this.addSublimationRecipe(ModMetals.ASTRAL_SILVER, 3, new PotionEffect(MobEffects.field_76439_r, 18000));
        this.addSublimationRecipe(ModMetals.BLACK_STEEL, 3, new PotionEffect(MobEffects.field_76429_m, 18000));
        this.addSublimationRecipe(ModMetals.CARMOT, 4, new PotionEffect(MobEffects.field_76422_e, 21600));
        this.addSublimationRecipe(ModMetals.DEEP_IRON, 4, new PotionEffect(MobEffects.field_76427_o, 24000));
        this.addSublimationRecipe(ModMetals.IGNATIUS, 4, new PotionEffect(MobEffects.field_76426_n, 18000));
        this.addSublimationRecipe(ModMetals.KALENDRITE, 4, new PotionEffect(MobEffects.field_76428_l, 24000, 1));
        this.addSublimationRecipe(ModMetals.LEMURITE, 3, new PotionEffect(MobEffects.field_76441_p, 19200));
        this.addSublimationRecipe(ModMetals.LUTETIUM, 4, new PotionEffect(MobEffects.field_188424_y, 24000));
        this.addSublimationRecipe(ModMetals.MIDASIUM, 3, new PotionEffect(MobEffects.field_188425_z, 21600));
        this.addSublimationRecipe(ModMetals.ORICHALCUM, 3, new PotionEffect(MobEffects.field_76420_g, 21600, 1));
        this.addSublimationRecipe(ModMetals.QUICKSILVER, 4, new PotionEffect(MobEffects.field_76424_c, 24000, 1));
        this.addSublimationRecipe(ModMetals.SANGUINITE, 3, new PotionEffect(MobEffects.field_76443_y, 19200));
    }

    private void addSublimationRecipe(Metal input, int amount, PotionEffect potionEffect) {
        if (input == null) {
            return;
        }
        this.addSublimationRecipe(new ItemStack((Block)input.getBlock(BlockTypes.BLOCK), amount), potionEffect);
    }

    public void addSublimationRecipe(ItemStack input, PotionEffect potion) {
        if (input.func_190926_b() || potion == null) {
            return;
        }
        if (this.getSublimationResult(input) != null) {
            return;
        }
        this.sublimationList.put(input, potion);
    }

    public void removeSublimationRecipe(Potion output) {
        ItemStack keyToRemove = ItemStack.field_190927_a;
        for (Map.Entry<ItemStack, PotionEffect> entry : this.sublimationList.entrySet()) {
            if (output != entry.getValue().func_188419_a()) continue;
            keyToRemove = entry.getKey();
        }
        if (!keyToRemove.func_190926_b()) {
            this.sublimationList.remove(keyToRemove);
        }
    }

    public PotionEffect getSublimationResult(ItemStack input) {
        for (Map.Entry<ItemStack, PotionEffect> entry : this.sublimationList.entrySet()) {
            if (!this.compareItemStacks(entry.getKey(), input) || entry.getKey().func_190916_E() != input.func_190916_E()) continue;
            return entry.getValue();
        }
        return null;
    }

    public int getSublimationBlockAmount(ItemStack input) {
        for (Map.Entry<ItemStack, PotionEffect> entry : this.sublimationList.entrySet()) {
            if (!this.compareItemStacks(entry.getKey(), input)) continue;
            return entry.getKey().func_190916_E();
        }
        return 0;
    }

    public Map<ItemStack, PotionEffect> recipesMap() {
        return this.sublimationList;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }
}

