/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.gadget.ItemOreDetector;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDetectorRecipe
extends ShapelessOreRecipe {
    private OreDetectorRecipe(NonNullList<Ingredient> input) {
        super(null, input, ItemStack.field_190927_a);
    }

    private boolean isCleaningRecipe(InventoryCrafting inv) {
        Item anyItemReally = null;
        int stackCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            anyItemReally = inv.func_70301_a(i).func_77973_b();
            ++stackCount;
        }
        return stackCount == 1 && anyItemReally == ModItems.ORE_DETECTOR;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack output = ItemStack.field_190927_a;
        NonNullList inputs = NonNullList.func_191196_a();
        Metal metalModel = null;
        if (this.isCleaningRecipe(inv)) {
            return new ItemStack((Item)ModItems.ORE_DETECTOR);
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Metal otherMetal = ItemUtils.getMetalFromOreDictStack(stack);
            if (otherMetal != null) {
                if (otherMetal == metalModel || otherMetal.isAlloy()) {
                    return ItemStack.field_190927_a;
                }
                inputs.add((Object)stack);
                metalModel = otherMetal;
                continue;
            }
            if (stack.func_77973_b() != ModItems.ORE_DETECTOR) continue;
            if (!ItemOreDetector.getDetectorMetals(stack).isEmpty()) {
                return ItemStack.field_190927_a;
            }
            output = stack.func_77946_l();
        }
        if (metalModel == null) {
            return output;
        }
        ItemOreDetector.addIngotsToDetector(output, (List<ItemStack>)inputs);
        return output;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        if (this.isCleaningRecipe(inv)) {
            return true;
        }
        return super.func_77569_a(inv, world);
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            NonNullList ingredients = NonNullList.func_191196_a();
            JsonArray jsonIngredients = JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            return new OreDetectorRecipe(ingredients);
        }
    }
}

