/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import com.google.common.collect.Maps;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class CrusherRecipes {
    private static final CrusherRecipes INSTANCE = new CrusherRecipes();
    private final Map<ItemStack, ItemStack> crushingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();
    private static final List<ItemStack> stackBlacklist = new ArrayList<ItemStack>();

    public static CrusherRecipes getInstance() {
        return INSTANCE;
    }

    private CrusherRecipes() {
        ModMetals.metalMap.forEach((name, m) -> {
            if (m.getOre() != null) {
                this.addCrushingRecipe(new ItemStack((Block)m.getOre(), 1), new ItemStack((Item)m.getDust(), 2), 0.75f);
            }
            this.addCrushingRecipe(new ItemStack((Item)m.getIngot()), new ItemStack((Item)m.getDust()), 0.0f);
        });
        this.addCrushingRecipe(new ItemStack(Blocks.field_150352_o), new ItemStack((Item)ModItems.GOLD_DUST, 2), 0.75f);
        this.addCrushingRecipe(new ItemStack(Blocks.field_150366_p), new ItemStack((Item)ModItems.IRON_DUST, 2), 0.75f);
        this.addCrushingRecipe(new ItemStack((Block)ModBlocks.oreTar), new ItemStack((Item)ModItems.TAR, 4), 0.75f);
        this.addCrushingRecipe(new ItemStack((Block)ModBlocks.orePhosphorite), new ItemStack((Item)ModItems.PHOSPHORUS, 4), 0.75f);
        this.addCrushingRecipe(new ItemStack((Block)ModBlocks.orePotash), new ItemStack((Item)ModItems.POTASH, 4), 0.75f);
        this.addCrushingRecipe(new ItemStack((Block)ModBlocks.oreSulfur), new ItemStack((Item)ModItems.SULFUR, 4), 0.75f);
        this.addCrushingRecipe(new ItemStack((Item)ModItems.POTASH), new ItemStack((Item)ModItems.DUST_POTASH), 1.0f);
        this.addCrushingRecipe(new ItemStack(Items.field_151043_k), new ItemStack((Item)ModItems.GOLD_DUST), 0.0f);
        this.addCrushingRecipe(new ItemStack(Items.field_151042_j), new ItemStack((Item)ModItems.IRON_DUST), 0.0f);
    }

    public void addCrushingRecipe(ItemStack input, ItemStack result, float experience) {
        if (input.func_190926_b() || result.func_190926_b()) {
            return;
        }
        for (ItemStack stack : this.crushingList.keySet()) {
            if (!input.func_77969_a(stack)) continue;
            return;
        }
        this.crushingList.put(input.func_77946_l(), result.func_77946_l());
        this.experienceList.put(result.func_77946_l(), Float.valueOf(experience));
    }

    public void removeCrushingRecipe(ItemStack output) {
        ArrayList<ItemStack> keysToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, ItemStack> entry : this.crushingList.entrySet()) {
            if (output.func_77973_b() != entry.getValue().func_77973_b()) continue;
            keysToRemove.add(entry.getKey());
        }
        if (!keysToRemove.isEmpty()) {
            for (ItemStack stack : keysToRemove) {
                this.crushingList.remove(stack);
                this.experienceList.remove(output);
                stackBlacklist.add(stack);
            }
        }
    }

    public ItemStack getCrushingResult(ItemStack input) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.crushingList.entrySet()) {
            ItemStack recipeInput = entry.getKey();
            if (!this.isValidInput(input, recipeInput)) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean isValidInput(ItemStack input, ItemStack recipeInput) {
        if (OreDictionary.itemMatches((ItemStack)input, (ItemStack)recipeInput, (boolean)false)) {
            return true;
        }
        return Arrays.stream(OreDictionary.getOreIDs((ItemStack)input)).filter(oreId -> {
            String oreKey = OreDictionary.getOreName((int)oreId);
            return oreKey.startsWith("ore") || oreKey.startsWith("ingot");
        }).anyMatch(inputId -> {
            for (int recipeId : OreDictionary.getOreIDs((ItemStack)recipeInput)) {
                if (recipeId != inputId) continue;
                return true;
            }
            return false;
        });
    }

    public float getCrushingExperience(ItemStack stack) {
        for (ItemStack in : this.experienceList.keySet()) {
            if (!in.func_77969_a(stack) && (in.func_77973_b() != stack.func_77973_b() || in.func_77952_i() != Short.MAX_VALUE)) continue;
            return this.experienceList.get(in).floatValue();
        }
        return 0.0f;
    }

    public Map<ItemStack, ItemStack> getRecipeMap() {
        return this.crushingList;
    }

    @Deprecated
    public static void registerDefaultOreRecipes() {
        for (String ore : OreDictionary.getOreNames()) {
            CrusherRecipes.add(ore, "ore", "dust", 2, 0.75f);
            CrusherRecipes.add(ore, "ore", "gem", 2, 0.5f);
            CrusherRecipes.add(ore, "ingot", "dust", 1, 0.1f);
        }
    }

    @Deprecated
    private static void add(String ore, String in, String out, int amount, float exp) {
        if (ore.length() <= in.length()) {
            return;
        }
        String mat = ore.substring(in.length());
        NonNullList outs = OreDictionary.getOres((String)(out + mat));
        if (ore.startsWith(in) && !outs.isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                if (CrusherRecipes.getInstance().crushingList.containsKey(stack) || !stackBlacklist.stream().noneMatch(blacklistStack -> ItemStack.func_77989_b((ItemStack)blacklistStack, (ItemStack)stack))) continue;
                CrusherRecipes.getInstance().addCrushingRecipe(stack, ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)outs.get(0)), (int)amount), exp);
            }
        }
    }
}

