/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.model.MetalSample;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class AlloyerRecipes {
    private static final AlloyerRecipes INSTANCE = new AlloyerRecipes();
    private final Table<MetalSample, MetalSample, MetalSample> alloyingList = HashBasedTable.create();
    private final Map<MetalSample, Pair<MetalSample, MetalSample>> ingredientsCache = new HashMap<MetalSample, Pair<MetalSample, MetalSample>>();

    public static AlloyerRecipes getInstance() {
        return INSTANCE;
    }

    private AlloyerRecipes() {
        this.addAlloyRecipe(new MetalSample(ModMetals.COPPER, 3), new MetalSample(ModMetals.TIN, 1), new MetalSample(ModMetals.BRONZE, 4, 1.75f));
        this.addAlloyRecipe(new MetalSample(ModMetals.SHADOW_IRON, 2), new MetalSample(ModMetals.LEMURITE, 1), new MetalSample(ModMetals.SHADOW_STEEL, 3, 1.5f));
        this.addAlloyRecipe(new MetalSample(ModMetals.ALDUORITE, 1), new MetalSample(ModMetals.CERUCLASE, 1), new MetalSample(ModMetals.INOLASHITE, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.COPPER, 3), new MetalSample(ModMetals.ZINC, 1), new MetalSample(ModMetals.BRASS, 4, 1.75f));
        this.addAlloyRecipe(new MetalSample(ModMetals.DEEP_IRON, 3), new MetalSample(ModMetals.INFUSCOLIUM, 1), new MetalSample(ModMetals.BLACK_STEEL, 4, 1.75f));
        this.addAlloyRecipe(new MetalSample(new ItemStack(Items.field_151042_j), 1), new MetalSample(ModMetals.MANGANESE, 2), new MetalSample(ModMetals.STEEL, 2, 1.5f));
        this.addAlloyRecipe(new MetalSample(new ItemStack((Item)ModItems.IRON_DUST), 1), new MetalSample(ModMetals.MANGANESE, 2), new MetalSample(ModMetals.STEEL, 2, 1.5f));
        this.addAlloyRecipe(new MetalSample(new ItemStack(Items.field_151042_j), 1), new MetalSample(ModMetals.BRONZE, 2), new MetalSample(ModMetals.DAMASCUS_STEEL, 3, 1.5f));
        this.addAlloyRecipe(new MetalSample(new ItemStack((Item)ModItems.IRON_DUST), 1), new MetalSample(ModMetals.BRONZE, 2), new MetalSample(ModMetals.DAMASCUS_STEEL, 3, 1.5f));
        this.addAlloyRecipe(new MetalSample(ModMetals.SILVER, 1), new MetalSample(new ItemStack(Items.field_151043_k), 1), new MetalSample(ModMetals.ELECTRUM, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.SILVER, 1), new MetalSample(new ItemStack((Item)ModItems.GOLD_DUST), 1), new MetalSample(ModMetals.ELECTRUM, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.ORICHALCUM, 1), new MetalSample(ModMetals.PLATINUM, 1), new MetalSample(ModMetals.CELENEGIL, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.KALENDRITE, 1), new MetalSample(ModMetals.PLATINUM, 1), new MetalSample(ModMetals.AMORDRINE, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.MITHRIL, 1), new MetalSample(ModMetals.RUBRACIUM, 2), new MetalSample(ModMetals.HADEROTH, 3, 1.5f));
        this.addAlloyRecipe(new MetalSample(ModMetals.ADAMANTINE, 1), new MetalSample(ModMetals.ATLARUS, 1), new MetalSample(ModMetals.TARTARITE, 1, 1.5f));
        this.addAlloyRecipe(new MetalSample(ModMetals.EXIMITE, 1), new MetalSample(ModMetals.MEUTOITE, 1), new MetalSample(ModMetals.DESICHALKOS, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(new ItemStack(Items.field_151043_k), 1), new MetalSample(new ItemStack(Items.field_151042_j), 1), new MetalSample(ModMetals.ANGMALLEN, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(new ItemStack((Item)ModItems.GOLD_DUST), 1), new MetalSample(new ItemStack((Item)ModItems.IRON_DUST), 1), new MetalSample(ModMetals.ANGMALLEN, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.INFUSCOLIUM, 1), new MetalSample(ModMetals.STEEL, 1), new MetalSample(ModMetals.HEPATIZON, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.SILVER, 1), new MetalSample(ModMetals.ASTRAL_SILVER, 1), new MetalSample(ModMetals.QUICKSILVER, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.LUTETIUM, 1), new MetalSample(ModMetals.OSMIUM, 1), new MetalSample(ModMetals.KRIK, 2, 1.25f));
        this.addAlloyRecipe(new MetalSample(ModMetals.SANGUINITE, 1), new MetalSample(ModMetals.ALDUORITE, 1), new MetalSample(ModMetals.ETHERIUM, 2, 1.25f));
    }

    public void addCustomAlloyRecipe(ItemStack input1, ItemStack input2, ItemStack result, float xp) {
        if (input1.func_190926_b() || input2.func_190926_b() || result.func_190926_b()) {
            return;
        }
        if (this.getAlloyResult(input1, input2) != ItemStack.field_190927_a) {
            return;
        }
        this.alloyingList.put((Object)new MetalSample(input1, input1.func_190916_E()), (Object)new MetalSample(input2, input2.func_190916_E()), (Object)new MetalSample(result, result.func_190916_E()).setXp(xp));
    }

    private void addAlloyRecipe(MetalSample input1, MetalSample input2, MetalSample result) {
        if (!(input1.getStack().func_190926_b() || input2.getStack().func_190926_b() || result.getStack().func_190926_b())) {
            this.alloyingList.put((Object)input1, (Object)input2, (Object)result);
            this.ingredientsCache.put(result, (Pair<MetalSample, MetalSample>)Pair.of((Object)input1, (Object)input2));
        }
    }

    public void removeAlloyRecipe(ItemStack output) {
        Set<Table.Cell> recipesToRemove = this.alloyingList.cellSet().stream().filter(cell -> this.compareItemStackToAlloySample(output, (MetalSample)cell.getValue())).collect(Collectors.toSet());
        if (!recipesToRemove.isEmpty()) {
            recipesToRemove.forEach(alloyCell -> {
                MetalSample cfr_ignored_0 = (MetalSample)this.alloyingList.remove(alloyCell.getRowKey(), alloyCell.getColumnKey());
            });
        }
    }

    public ItemStack getAlloyResult(ItemStack input1, ItemStack input2) {
        if (input1.func_190926_b() || input2.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Optional<Table.Cell> result = this.alloyingList.cellSet().stream().filter(cell -> this.compareItemStackToAlloySample(input1, (MetalSample)cell.getRowKey()) && this.compareItemStackToAlloySample(input2, (MetalSample)cell.getColumnKey()) || this.compareItemStackToAlloySample(input1, (MetalSample)cell.getColumnKey()) && this.compareItemStackToAlloySample(input2, (MetalSample)cell.getRowKey())).findFirst();
        if (result.isPresent()) {
            MetalSample alloyResult = (MetalSample)result.get().getValue();
            return alloyResult.getStack();
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public Pair<MetalSample, MetalSample> getIngredients(ItemStack alloy) {
        return this.ingredientsCache.entrySet().stream().filter(cell -> this.compareItemStackToAlloySample(alloy, (MetalSample)cell.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public boolean isAlloyMetal(ItemStack input1) {
        return this.alloyingList.cellSet().stream().anyMatch(cell -> this.compareItemStackToAlloySample(input1, (MetalSample)cell.getRowKey()) || this.compareItemStackToAlloySample(input1, (MetalSample)cell.getColumnKey()));
    }

    private boolean compareItemStackToAlloySample(ItemStack stack, MetalSample alloySample) {
        Metal metal = ItemUtils.getMetalFromOreDictStack(stack);
        if (metal == null && !alloySample.hasFallenBack()) {
            return false;
        }
        if (alloySample.hasFallenBack()) {
            return this.compareItemStacks(stack, alloySample.getFallbackStack());
        }
        return Utils.listContains(alloySample.getOredictedStacks(), stack, this::compareItemStacks);
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public float getAlloyExperience(ItemStack stack) {
        Optional<MetalSample> result = this.alloyingList.cellSet().stream().map(Table.Cell::getValue).filter(resultAlloy -> this.compareItemStackToAlloySample(stack, (MetalSample)resultAlloy)).findFirst();
        return result.filter(MetalSample::hasXp).map(MetalSample::getXp).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getItemQuantity(ItemStack result, ItemStack input) {
        for (Table.Cell cell : this.alloyingList.cellSet()) {
            if (!this.compareItemStackToAlloySample(result, (MetalSample)cell.getValue())) continue;
            if (this.compareItemStackToAlloySample(input, (MetalSample)cell.getRowKey())) {
                return ((MetalSample)cell.getRowKey()).getAmount();
            }
            if (!this.compareItemStackToAlloySample(input, (MetalSample)cell.getColumnKey())) continue;
            return ((MetalSample)cell.getColumnKey()).getAmount();
        }
        return 0;
    }

    public Table<MetalSample, MetalSample, MetalSample> getRecipeTable() {
        return this.alloyingList;
    }
}

