/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.proxy;

import it.hurts.metallurgy_reforged.entity.EntityPierKnight;
import it.hurts.metallurgy_reforged.entity.MetallurgyPrimedTNT;
import it.hurts.metallurgy_reforged.gui.TooltipRenderHandler;
import it.hurts.metallurgy_reforged.gui.hud.HUDHandler;
import it.hurts.metallurgy_reforged.handler.ClientEventsHandler;
import it.hurts.metallurgy_reforged.integration.tic.material.TiCMaterials;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.gadget.ItemOreDetector;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.particle.ParticleOre;
import it.hurts.metallurgy_reforged.proxy.IProxy;
import it.hurts.metallurgy_reforged.render.MetallurgyTNTRenderer;
import it.hurts.metallurgy_reforged.render.PierKnightRenderer;
import it.hurts.metallurgy_reforged.render.font.ModFontRenderer;
import it.hurts.metallurgy_reforged.sound.ModSounds;
import it.hurts.metallurgy_reforged.util.ModChecker;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
implements IProxy {
    public static ModFontRenderer fontRenderer;
    public static Minecraft client;

    public static void clientSpawnParticle(World world, double x, double y, double z, float scale, float red, float green, float blue, boolean dynamic, int level) {
        ClientProxy.client.field_71452_i.func_78873_a((Particle)new ParticleOre(world, x, y, z, scale, red, green, blue, dynamic, level));
    }

    public static void clientSpawnParticle(World world, double x, double y, double z, double speedX, double speedY, double speedZ, float scale, float red, float green, float blue, boolean dynamic, int level) {
        ClientProxy.client.field_71452_i.func_78873_a((Particle)new ParticleOre(world, x, y, z, speedX, speedY, speedZ, scale, red, green, blue, dynamic, level));
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        if (ModChecker.isTConLoaded) {
            TiCMaterials.initializeRenderInfos();
        }
        MinecraftForge.EVENT_BUS.register(ClientEventsHandler.class);
        MinecraftForge.EVENT_BUS.register(HUDHandler.class);
        MinecraftForge.EVENT_BUS.register(TooltipRenderHandler.class);
        ModItems.BRASS_KNUCKLES.initTEISR();
        RenderingRegistry.registerEntityRenderingHandler(EntityPierKnight.class, PierKnightRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MetallurgyPrimedTNT.class, MetallurgyTNTRenderer::new);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            List<Metal> metals = ItemOreDetector.getDetectorMetals(stack);
            if (tintIndex < metals.size()) {
                int color = metals.get(tintIndex).getStats().getColorHex();
                if (ModItems.ORE_DETECTOR.isLEDLit(tintIndex)) {
                    if (Minecraft.func_71410_x().field_71441_e.func_82737_E() % 10L == 5L) {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a(ModSounds.METAL_DETECTOR_BEEPS[tintIndex], 1.0f, 1.0f);
                    }
                    if (Minecraft.func_71410_x().field_71441_e.func_82737_E() % 10L > 4L) {
                        return color ^ 0xFFFFFF;
                    }
                    return color;
                }
                return color;
            }
            return -1;
        }, new Item[]{ModItems.ORE_DETECTOR});
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)client.func_110442_L();
        fontRenderer = new ModFontRenderer(ClientProxy.client.field_71474_y, new ResourceLocation("textures/font/ascii.png"), ClientProxy.client.field_71446_o);
        if (ClientProxy.client.field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78264_a(client.func_135016_M().func_135042_a() || ClientProxy.client.field_71474_y.field_151455_aw);
            fontRenderer.func_78275_b(client.func_135016_M().func_135044_b());
        }
        resourceManager.func_110542_a((IResourceManagerReloadListener)fontRenderer);
    }

    static {
        client = Minecraft.func_71410_x();
    }
}

