/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.particle;

import it.hurts.metallurgy_reforged.Metallurgy;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleOre
extends Particle {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[10];
    private int textureIndex = 0;
    private final int level;
    private final float particleOreScale;
    private final boolean dynamic;

    public ParticleOre(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, float scale, float red, float green, float blue, boolean dynamic, int level) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, scale, red, green, blue, dynamic, level);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
    }

    public ParticleOre(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, float red, float green, float blue, boolean dynamic, int level) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.field_70547_e = (int)(32.0 + Math.random() * 0.4);
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        if (level > 9) {
            Metallurgy.logger.error("Level Particle Too High, Max 9");
            level = 9;
        }
        this.level = level;
        float f = (float)Math.random() * 0.4f + 0.6f;
        this.field_70552_h = ((float)(Math.random() * (double)0.2f) + 0.8f) * red * f;
        this.field_70553_i = ((float)(Math.random() * (double)0.2f) + 0.8f) * green * f;
        this.field_70551_j = ((float)(Math.random() * (double)0.2f) + 0.8f) * blue * f;
        this.field_70544_f *= 0.75f;
        this.field_70544_f *= scale;
        this.particleOreScale = this.field_70544_f;
        this.field_187129_i *= (double)0.1f;
        this.field_187130_j *= (double)0.1f;
        this.field_187131_k *= (double)0.1f;
        this.func_187117_a(Minecraft.func_71410_x().func_147117_R().func_110572_b(TEXTURES[dynamic ? 0 : level].toString()));
        this.dynamic = dynamic;
    }

    public void setMotionMultiplier(float motion) {
        this.field_187129_i *= (double)motion;
        this.field_187130_j *= (double)motion;
        this.field_187131_k *= (double)motion;
    }

    public void func_180434_a(@Nonnull BufferBuilder buffer, @Nonnull Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float currentAge = (float)this.field_70546_d + partialTicks;
        float scaleStartTimeStamp = (float)this.field_70547_e * 0.7f;
        if (currentAge >= scaleStartTimeStamp) {
            float scaledMaxAge = (float)this.field_70547_e - scaleStartTimeStamp;
            float scaledCurrentAge = currentAge - scaleStartTimeStamp;
            float particleAnimator = 1.0f - MathHelper.func_76131_a((float)(scaledCurrentAge / scaledMaxAge), (float)0.0f, (float)1.0f);
            this.field_70544_f = this.particleOreScale * particleAnimator;
        }
        super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        int prevTextureIndex = this.textureIndex;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        int tickStep = this.field_70547_e / 7;
        if (this.dynamic && this.field_70546_d % tickStep == 0) {
            ++this.textureIndex;
            if (this.textureIndex > this.level) {
                this.textureIndex = 0;
            }
            if (prevTextureIndex != this.textureIndex) {
                this.func_187117_a(Minecraft.func_71410_x().func_147117_R().func_110572_b(TEXTURES[this.textureIndex].toString()));
            }
        }
    }

    static {
        for (int i = 0; i < 10; ++i) {
            ParticleOre.TEXTURES[i] = new ResourceLocation("metallurgy", "particles/ore_particle_" + (i + 1));
        }
    }
}

