/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.network.server;

import io.netty.buffer.ByteBuf;
import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.network.client.PacketAttachEmitter;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketAmordrineJump
implements IMessage {
    private int maxJumps;

    public PacketAmordrineJump() {
    }

    public PacketAmordrineJump(int maxJumps) {
        this.maxJumps = maxJumps;
    }

    public void fromBytes(ByteBuf buf) {
        this.maxJumps = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.maxJumps);
    }

    public static class Handler
    implements IMessageHandler<PacketAmordrineJump, PacketAttachEmitter> {
        public PacketAttachEmitter onMessage(PacketAmordrineJump message, MessageContext ctx) {
            int currentJumps;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            PlayerEffectData capability = (PlayerEffectData)player.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
            if (capability != null && (currentJumps = capability.getAmordrineJumps()) < message.maxJumps) {
                capability.setAmordrineJumps(currentJumps + 1);
                player.func_70664_aZ();
                player.field_70181_x += 0.15;
                player.field_70133_I = true;
                player.field_70143_R = 0.0f;
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187524_aN, SoundCategory.PLAYERS, 0.5f, 2.0f);
                AxisAlignedBB playerBox = player.func_174813_aQ();
                AxisAlignedBB feetBox = new AxisAlignedBB(playerBox.field_72340_a, playerBox.field_72338_b, playerBox.field_72339_c, playerBox.field_72336_d, playerBox.field_72338_b, playerBox.field_72334_f).func_72314_b(0.7, 0.0, 0.7);
                return new PacketAttachEmitter(feetBox, 0.0, -0.03, 0.0, ModMetals.AMORDRINE.getStats().getColorHex(), 1.0f, false, 4 - currentJumps, 10);
            }
            return null;
        }
    }
}

