/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.network.client;

import io.netty.buffer.ByteBuf;
import it.hurts.metallurgy_reforged.capabilities.effect.BlockInfoDataBundle;
import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSyncEffectBundle
implements IMessage {
    private byte bundleType;
    private String prefixKey;
    private int step;
    private long timestamp;
    private boolean paused;
    private ItemStack effectStack;
    @Nullable
    private NBTTagCompound extras;
    @Nullable
    private BlockPos blockPos;

    public PacketSyncEffectBundle() {
    }

    public PacketSyncEffectBundle(String prefixKey, ProgressiveDataBundle bundle) {
        this.bundleType = bundle.getType();
        this.prefixKey = prefixKey;
        this.step = bundle.getCurrentStep();
        this.timestamp = bundle.getPrevStepTime();
        this.paused = bundle.isPaused();
        this.effectStack = bundle.getEffectStack();
        if (bundle.getType() == 1) {
            this.blockPos = ((BlockInfoDataBundle)bundle).getPos();
        } else if (bundle.getType() == 2) {
            this.extras = ((ExtraFilledDataBundle)bundle).getExtras();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.prefixKey = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.step = buf.readInt();
        this.timestamp = buf.readLong();
        this.paused = buf.readBoolean();
        this.effectStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        if (this.bundleType == 1) {
            this.blockPos = BlockPos.func_177969_a((long)buf.readLong());
        }
        if (this.bundleType == 2) {
            this.extras = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.prefixKey);
        buf.writeInt(this.step);
        buf.writeLong(this.timestamp);
        buf.writeBoolean(this.paused);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.effectStack);
        if (this.blockPos != null && this.bundleType == 1) {
            buf.writeLong(this.blockPos.func_177986_g());
        }
        if (this.extras != null && this.bundleType == 2) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.extras);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncEffectBundle, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketSyncEffectBundle message, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_152344_a(() -> {
                ProgressiveDataBundle bundle = ((PlayerEffectData)minecraft.field_71439_g.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null)).effectBundles.get(message.prefixKey);
                if (bundle.getCurrentStep() != message.step) {
                    bundle.setCurrentStep(message.step, null);
                }
                if (bundle.getPrevStepTime() == -1L) {
                    bundle.updateTimeStamp((EntityPlayer)minecraft.field_71439_g);
                }
                if (bundle.getEffectStack().func_190926_b()) {
                    bundle.setEffectStack(message.effectStack, null);
                }
                if (bundle.isPaused() != message.paused) {
                    bundle.setPaused(message.paused, null);
                }
                if (message.bundleType == 1 && message.blockPos != ((BlockInfoDataBundle)bundle).getPos()) {
                    ((BlockInfoDataBundle)bundle).setBlockInfo(message.blockPos, null);
                }
                if (message.bundleType == 2 && message.extras != ((ExtraFilledDataBundle)bundle).getExtras()) {
                    ((ExtraFilledDataBundle)bundle).setExtras(message.extras);
                }
            });
            return null;
        }
    }
}

