/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.network.client;

import io.netty.buffer.ByteBuf;
import it.hurts.metallurgy_reforged.particle.ParticleOre;
import it.hurts.metallurgy_reforged.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSpawnOreParticles
implements IMessage {
    private double x;
    private double y;
    private double z;
    private int color;
    private float scale;
    private int level;
    private double motionX;
    private double motionY;
    private double motionZ;
    private boolean dynamic;
    private boolean hasMotion = false;

    public PacketSpawnOreParticles() {
    }

    public PacketSpawnOreParticles(double x, double y, double z, double motionX, double motionY, double motionZ, int color, float scale, boolean dynamic, int level) {
        this(x, y, z, color, scale, dynamic, level);
        this.hasMotion = true;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public PacketSpawnOreParticles(double x, double y, double z, int color, float scale, boolean dynamic, int level) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.scale = scale;
        this.level = level;
        this.dynamic = dynamic;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.color = buf.readInt();
        this.scale = buf.readFloat();
        this.dynamic = buf.readBoolean();
        this.level = buf.readInt();
        this.hasMotion = buf.readBoolean();
        if (this.hasMotion) {
            this.motionX = buf.readDouble();
            this.motionY = buf.readDouble();
            this.motionZ = buf.readDouble();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.color);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.dynamic);
        buf.writeInt(this.level);
        buf.writeBoolean(this.hasMotion);
        if (this.hasMotion) {
            buf.writeDouble(this.motionX);
            buf.writeDouble(this.motionY);
            buf.writeDouble(this.motionZ);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnOreParticles, IMessage> {
        private final float[] rgb = new float[3];

        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketSpawnOreParticles message, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Utils.getRGBComponents(message.color, this.rgb);
            minecraft.func_152344_a(() -> {
                ParticleOre particleOre = message.hasMotion ? new ParticleOre((World)minecraft.field_71441_e, message.x, message.y, message.z, message.motionX, message.motionY, message.motionZ, message.scale, this.rgb[0], this.rgb[1], this.rgb[2], message.dynamic, message.level) : new ParticleOre((World)minecraft.field_71441_e, message.x, message.y, message.z, message.scale, this.rgb[0], this.rgb[1], this.rgb[2], message.dynamic, message.level);
                minecraft.field_71452_i.func_78873_a((Particle)particleOre);
            });
            return null;
        }
    }
}

