/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.network.client;

import io.netty.buffer.ByteBuf;
import it.hurts.metallurgy_reforged.world.explosive.ExplosiveType;
import it.hurts.metallurgy_reforged.world.explosive.MetallurgyExplosion;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketMetallurgyExplosion
implements IMessage {
    private double x;
    private double y;
    private double z;
    private float motionX;
    private float motionY;
    private float motionZ;
    private List<BlockPos> affectedBlockPositions;
    private ExplosiveType explosionType;

    public PacketMetallurgyExplosion() {
    }

    public PacketMetallurgyExplosion(double x, double y, double z, @Nullable Vec3d motion, List<BlockPos> affectedBlockPositions, ExplosiveType explosionType) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.affectedBlockPositions = affectedBlockPositions;
        this.explosionType = explosionType;
        if (motion != null) {
            this.motionX = (float)motion.field_72450_a;
            this.motionY = (float)motion.field_72448_b;
            this.motionZ = (float)motion.field_72449_c;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.motionX = buf.readFloat();
        this.motionY = buf.readFloat();
        this.motionZ = buf.readFloat();
        this.explosionType = ExplosiveType.byIndex(buf.readInt());
        int size = buf.readInt();
        this.affectedBlockPositions = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            this.affectedBlockPositions.add(BlockPos.func_177969_a((long)buf.readLong()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionY);
        buf.writeFloat(this.motionZ);
        buf.writeInt(this.explosionType.ordinal());
        buf.writeInt(this.affectedBlockPositions.size());
        this.affectedBlockPositions.forEach(pos -> buf.writeLong(pos.func_177986_g()));
    }

    public static class Handler
    implements IMessageHandler<PacketMetallurgyExplosion, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketMetallurgyExplosion message, MessageContext ctx) {
            Minecraft client = Minecraft.func_71410_x();
            client.func_152344_a(() -> {
                MetallurgyExplosion explosion = new MetallurgyExplosion((World)client.field_71441_e, null, message.x, message.y, message.z, message.affectedBlockPositions, message.explosionType);
                explosion.func_77279_a(true);
                client.field_71439_g.field_70159_w += (double)message.motionX;
                client.field_71439_g.field_70181_x += (double)message.motionY;
                client.field_71439_g.field_70179_y += (double)message.motionZ;
            });
            return null;
        }
    }
}

