/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.network.client;

import io.netty.buffer.ByteBuf;
import it.hurts.metallurgy_reforged.particle.ParticleOreEmitter;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketAttachEmitter
implements IMessage {
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    private double z1;
    private double z2;
    private int color;
    private float scale;
    private int level;
    private int lifetime;
    private boolean dynamic;
    private double motionX;
    private double motionY;
    private double motionZ;
    private boolean hasMotion = false;

    public PacketAttachEmitter() {
    }

    public PacketAttachEmitter(AxisAlignedBB aabb, double motionX, double motionY, double motionZ, int color, float scale, boolean dynamic, int level, int lifetime) {
        this(aabb, color, scale, dynamic, level, lifetime);
        this.hasMotion = true;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public PacketAttachEmitter(AxisAlignedBB aabb, int color, float scale, boolean dynamic, int level, int lifetime) {
        this.x1 = aabb.field_72340_a;
        this.x2 = aabb.field_72336_d;
        this.y1 = aabb.field_72338_b;
        this.y2 = aabb.field_72337_e;
        this.z1 = aabb.field_72339_c;
        this.z2 = aabb.field_72334_f;
        this.color = color;
        this.scale = scale;
        this.level = level;
        this.dynamic = dynamic;
        this.lifetime = lifetime;
    }

    public void fromBytes(ByteBuf buf) {
        this.x1 = buf.readDouble();
        this.x2 = buf.readDouble();
        this.y1 = buf.readDouble();
        this.y2 = buf.readDouble();
        this.z1 = buf.readDouble();
        this.z2 = buf.readDouble();
        this.color = buf.readInt();
        this.scale = buf.readFloat();
        this.dynamic = buf.readBoolean();
        this.level = buf.readInt();
        this.lifetime = buf.readInt();
        this.hasMotion = buf.readBoolean();
        if (this.hasMotion) {
            this.motionX = buf.readDouble();
            this.motionY = buf.readDouble();
            this.motionZ = buf.readDouble();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x1);
        buf.writeDouble(this.x2);
        buf.writeDouble(this.y1);
        buf.writeDouble(this.y2);
        buf.writeDouble(this.z1);
        buf.writeDouble(this.z2);
        buf.writeInt(this.color);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.dynamic);
        buf.writeInt(this.level);
        buf.writeInt(this.lifetime);
        buf.writeBoolean(this.hasMotion);
        if (this.hasMotion) {
            buf.writeDouble(this.motionX);
            buf.writeDouble(this.motionY);
            buf.writeDouble(this.motionZ);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketAttachEmitter, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketAttachEmitter message, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_152344_a(() -> {
                float[] rgb = new Color(message.color).getColorComponents(null);
                AxisAlignedBB box = new AxisAlignedBB(message.x1, message.y1, message.z1, message.x2, message.y2, message.z2);
                ParticleOreEmitter particleOre = message.hasMotion ? new ParticleOreEmitter((World)minecraft.field_71441_e, box, message.motionX, message.motionY, message.motionZ, message.lifetime, rgb[0], rgb[1], rgb[2], message.dynamic, message.level) : new ParticleOreEmitter((World)minecraft.field_71441_e, box, message.lifetime, rgb[0], rgb[1], rgb[2], message.dynamic, message.level);
                minecraft.field_71452_i.func_78873_a((Particle)particleOre);
            });
            return null;
        }
    }
}

