/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.model;

import it.hurts.metallurgy_reforged.handler.OreDictHandler;
import it.hurts.metallurgy_reforged.material.Metal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@MethodsReturnNonnullByDefault
public class MetalSample {
    private final Metal metal;
    private ItemStack fallbackStack = ItemStack.field_190927_a;
    private final int amount;
    private final boolean isOriginal;
    private float xp = -1.0f;

    public MetalSample(Metal metal, int amount, float xp) {
        this.metal = metal;
        this.amount = amount;
        this.xp = xp;
        this.isOriginal = true;
    }

    public MetalSample(Metal metal, int amount) {
        this(metal, amount, -1.0f);
    }

    public MetalSample(ItemStack oreDictStack, int amount) {
        this.metal = null;
        this.fallbackStack = oreDictStack;
        this.amount = amount;
        this.isOriginal = false;
    }

    @Nullable
    public Metal getMetal() {
        return this.metal;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public float getXp() {
        return this.xp;
    }

    public boolean hasXp() {
        return this.xp != -1.0f;
    }

    public MetalSample setXp(float xp) {
        this.xp = xp;
        return this;
    }

    public boolean hasFallenBack() {
        return !this.fallbackStack.func_190926_b();
    }

    public List<ItemStack> getOredictedStacks() {
        if (this.hasFallenBack()) {
            return Collections.singletonList(this.fallbackStack);
        }
        List<ItemStack> copyList = OreDictHandler.ALLOYING_CACHE.get((Object)this.getMetal()).stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        copyList.forEach(stack -> stack.func_190920_e(this.getAmount()));
        return copyList;
    }

    public ItemStack getStack() {
        if (this.hasFallenBack() || this.metal == null) {
            return this.fallbackStack;
        }
        return new ItemStack((Item)this.metal.getIngot(), this.amount);
    }

    public ItemStack getFallbackStack() {
        return this.fallbackStack;
    }
}

