/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.material;

import it.hurts.metallurgy_reforged.block.BlockMetal;
import it.hurts.metallurgy_reforged.block.BlockOre;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.fluid.FluidMolten;
import it.hurts.metallurgy_reforged.item.ItemMetal;
import it.hurts.metallurgy_reforged.item.ItemTypes;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.ItemAxeBase;
import it.hurts.metallurgy_reforged.item.tool.ItemHoeBase;
import it.hurts.metallurgy_reforged.item.tool.ItemPickaxeBase;
import it.hurts.metallurgy_reforged.item.tool.ItemShovelBase;
import it.hurts.metallurgy_reforged.item.tool.ItemSwordBase;
import it.hurts.metallurgy_reforged.material.ArmorStats;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ToolStats;
import it.hurts.metallurgy_reforged.util.Constants;
import jline.internal.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public class MetalStats {
    private final String name;
    private final float hardness;
    private final float blockBlastResistance;
    private final int oreHarvest;
    private final int color;
    private final int temperature;
    private final ArmorStats armor;
    private final ToolStats tool;
    private Item.ToolMaterial toolMaterial;
    private ItemArmor.ArmorMaterial armorMaterial;

    public void createMetal() {
        ItemMetal dust = new ItemMetal(this, ItemTypes.DUST);
        ItemMetal ingot = new ItemMetal(this, ItemTypes.INGOT);
        ItemMetal nugget = new ItemMetal(this, ItemTypes.NUGGET);
        BlockMetal[] blocks = new BlockMetal[BlockTypes.values().length];
        for (int i = 0; i < BlockTypes.values().length; ++i) {
            blocks[i] = new BlockMetal(this, BlockTypes.values()[i], i == BlockTypes.BLOCK.ordinal() ? 5.0f : 2.0f);
        }
        BlockOre ore = null;
        if (this.oreHarvest >= 0) {
            ore = new BlockOre(this.name + "_ore", this.hardness, this.oreHarvest, this.blockBlastResistance, this);
        }
        FluidMolten moltenFluid = new FluidMolten(this.name, (int)this.getColorIntWithAlpha(), this.automaticTemperature());
        ItemArmorBase[] armorPieces = null;
        Item[] tools = null;
        if (this.armor != null) {
            ItemArmor.ArmorMaterial armorMaterial = this.createArmorMaterial();
            ItemArmorBase helmet = new ItemArmorBase(armorMaterial, EntityEquipmentSlot.HEAD, this);
            ItemArmorBase chestplate = new ItemArmorBase(armorMaterial, EntityEquipmentSlot.CHEST, this);
            ItemArmorBase leggings = new ItemArmorBase(armorMaterial, EntityEquipmentSlot.LEGS, this);
            ItemArmorBase boots = new ItemArmorBase(armorMaterial, EntityEquipmentSlot.FEET, this);
            armorPieces = new ItemArmorBase[]{helmet, chestplate, leggings, boots};
        }
        if (this.tool != null) {
            Item.ToolMaterial toolMaterial = this.createToolMaterial();
            ItemAxeBase axe = new ItemAxeBase(toolMaterial, this);
            ItemHoeBase hoe = new ItemHoeBase(toolMaterial, this);
            ItemPickaxeBase pickaxe = new ItemPickaxeBase(toolMaterial, this);
            ItemShovelBase shovel = new ItemShovelBase(toolMaterial, this);
            ItemSwordBase sword = new ItemSwordBase(toolMaterial, this);
            tools = new Item[]{axe, hoe, pickaxe, shovel, sword};
        }
        new Metal(this, ingot, dust, nugget, ore, blocks, moltenFluid, tools, armorPieces);
    }

    private int automaticTemperature() {
        int tier = this.oreHarvest;
        if (tier == -1) {
            tier = (Integer)Constants.TIER_MAP.get((Object)this.name);
        }
        return 1000 + tier * 200;
    }

    public MetalStats(String name, float hardness, float blastResistance, ArmorStats armor, ToolStats tool, int oreHarvest, int color, int temperature) {
        this.name = name;
        this.hardness = hardness;
        this.blockBlastResistance = blastResistance;
        this.armor = armor;
        this.tool = tool;
        this.oreHarvest = oreHarvest;
        this.color = color;
        this.temperature = temperature > 0 ? temperature : this.automaticTemperature();
    }

    public String getName() {
        return this.name;
    }

    public float getHardness() {
        return this.hardness;
    }

    public int getOreHarvest() {
        return this.oreHarvest;
    }

    public float getBlockBlastResistance() {
        return this.blockBlastResistance;
    }

    @Nullable
    public ArmorStats getArmorStats() {
        return this.armor;
    }

    @Nullable
    public ToolStats getToolStats() {
        return this.tool;
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    public int getColorHex() {
        return this.color;
    }

    public long getColorIntWithAlpha() {
        String colorWoAlpha = Integer.toHexString(this.color);
        String colorWAlpha = "0xff" + colorWoAlpha;
        return Long.decode(colorWAlpha);
    }

    public float[] getColorRGBValues() {
        float[] rgb = new float[]{(float)(this.color >> 16 & 0xFF) / 255.0f, (float)(this.color >> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f};
        return rgb;
    }

    public int getTemperature() {
        return this.temperature;
    }

    private ItemArmor.ArmorMaterial createArmorMaterial() {
        if (this.armor == null) {
            throw new UnsupportedOperationException("No Armor Stats Loaded");
        }
        this.armorMaterial = EnumHelper.addArmorMaterial((String)this.getName(), (String)("metallurgy:" + this.getName()), (int)this.armor.getDurability(), (int[])this.armor.getDamageReduction(), (int)this.armor.getEnchantability(), (SoundEvent)SoundEvents.field_187719_p, (float)this.armor.getToughness());
        return this.armorMaterial;
    }

    private Item.ToolMaterial createToolMaterial() {
        if (this.tool == null) {
            throw new UnsupportedOperationException("No Tool Stats Loaded");
        }
        this.toolMaterial = EnumHelper.addToolMaterial((String)this.getName(), (int)this.tool.getHarvestLevel(), (int)this.tool.getMaxUses(), (float)this.tool.getEfficiency(), (float)this.tool.getDamage(), (int)this.tool.getToolMagic());
        return this.toolMaterial;
    }
}

