/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.tool;

import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.proxy.ClientProxy;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShovelBase
extends ItemSpade
implements IToolEffect {
    private final Set<BaseMetallurgyEffect> effects = new HashSet<BaseMetallurgyEffect>();
    private Enchantment enchantment = null;
    private int enchantmentLevel = -1;
    private final MetalStats metalStats;

    public ItemShovelBase(Item.ToolMaterial material, MetalStats metalStats) {
        super(material);
        ItemUtils.initItem((Item)this, metalStats.getName() + "_shovel", MetallurgyTabs.tabTool);
        this.metalStats = metalStats;
    }

    @Override
    public EnumTools getToolClass() {
        return EnumTools.SHOVEL;
    }

    @Override
    public MetalStats getMetalStats() {
        return this.metalStats;
    }

    @Override
    public void addEffect(BaseMetallurgyEffect effect) {
        this.effects.add(effect);
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("durability_boost")) {
            float dBoost = compound.func_74760_g("durability_boost");
            return (int)(dBoost * (float)super.getMaxDamage(stack));
        }
        return super.getMaxDamage(stack);
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        NBTTagCompound data = stack.func_77978_p();
        if (data != null && data.func_74764_b("harvest_boost")) {
            return super.getHarvestLevel(stack, toolClass, player, blockState) + data.func_74762_e("harvest_boost");
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public void setEnchanted(Enchantment enchantment, int enchantmentLevel) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        Metal metal = ModMetals.metalMap.get(this.metalStats.getName());
        return GeneralConfig.enableAnvilToolRepair && ItemUtils.equalsWildcard(new ItemStack((Item)metal.getIngot()), repair) || super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        ItemUtils.buildStatsTooltip(tooltip, EnumTools.SHOVEL, this.metalStats.getToolStats(), stack);
        ItemUtils.buildEffectTooltip(tooltip, this.effects, stack, EnumTools.SHOVEL);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        this.effects.forEach(effect -> {
            if (effect.isEnabled()) {
                effect.rightClickHandler(worldIn, playerIn, handIn);
            }
        });
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        this.effects.forEach(effect -> {
            if (effect.isEnabled()) {
                effect.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(@Nonnull ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack enchantedShowel = new ItemStack((Item)this);
            if (this.enchantment != null) {
                enchantedShowel.func_77966_a(this.enchantment, this.enchantmentLevel);
            }
            items.add((Object)enchantedShowel);
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        ItemUtils.setToolAttributes(equipmentSlot, (Multimap<String, AttributeModifier>)multimap, this.metalStats);
        return multimap;
    }
}

