/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.tool;

import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.proxy.ClientProxy;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHoeBase
extends ItemHoe
implements IToolEffect {
    private final Set<BaseMetallurgyEffect> effects = new HashSet<BaseMetallurgyEffect>();
    private final MetalStats metalStats;

    public ItemHoeBase(Item.ToolMaterial material, MetalStats metalStats) {
        super(material);
        this.metalStats = metalStats;
        ItemUtils.initItem((Item)this, metalStats.getName() + "_hoe", MetallurgyTabs.tabTool);
    }

    private ItemStack getRepairStack() {
        Metal metal = ModMetals.metalMap.get(this.metalStats.getName());
        if (metal != null) {
            return new ItemStack((Item)metal.getIngot());
        }
        return ItemStack.field_190927_a;
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("durability_boost")) {
            float dBoost = compound.func_74760_g("durability_boost");
            return (int)(dBoost * (float)super.getMaxDamage(stack));
        }
        return super.getMaxDamage(stack);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return GeneralConfig.enableAnvilToolRepair && ItemUtils.equalsWildcard(this.getRepairStack(), repair) || super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        ItemUtils.buildStatsTooltip(tooltip, EnumTools.HOE, this.metalStats.getToolStats(), stack);
        ItemUtils.buildEffectTooltip(tooltip, this.effects, stack, EnumTools.HOE);
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        this.effects.forEach(effect -> {
            if (effect.isEnabled()) {
                effect.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(@Nonnull ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        ItemUtils.setToolAttributes(equipmentSlot, (Multimap<String, AttributeModifier>)multimap, this.metalStats);
        return multimap;
    }

    public int getItemEnchantability(@Nonnull ItemStack stack) {
        return this.metalStats.getToolStats().getToolMagic();
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        if (enchantment == Enchantments.field_185308_t) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public MetalStats getMetalStats() {
        return this.metalStats;
    }

    @Override
    public EnumTools getToolClass() {
        return EnumTools.HOE;
    }

    @Override
    public void addEffect(BaseMetallurgyEffect effect) {
        this.effects.add(effect);
    }
}

