/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.tool;

import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.item.tool.ItemAxeBase;
import it.hurts.metallurgy_reforged.item.tool.ItemHoeBase;
import it.hurts.metallurgy_reforged.item.tool.ItemPickaxeBase;
import it.hurts.metallurgy_reforged.item.tool.ItemShovelBase;
import it.hurts.metallurgy_reforged.item.tool.ItemSwordBase;
import javax.annotation.Nullable;
import net.minecraft.item.Item;

public enum EnumTools {
    AXE("axe", ItemAxeBase.class, RegistrationConfig.categoryItems.enableMetalAxes),
    HOE("hoe", ItemHoeBase.class, RegistrationConfig.categoryItems.enableMetalHoes),
    PICKAXE("pickaxe", ItemPickaxeBase.class, RegistrationConfig.categoryItems.enableMetalPickaxes),
    SHOVEL("shovel", ItemShovelBase.class, RegistrationConfig.categoryItems.enableMetalShovels),
    SWORD("sword", ItemSwordBase.class, RegistrationConfig.categoryItems.enableMetalSwords);

    private final String name;
    private final Class<?> toolClass;
    private final boolean isEnabled;

    private <T extends Item> EnumTools(String name, Class<T> toolClass, boolean enabled) {
        this.name = name;
        this.toolClass = toolClass;
        this.isEnabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public <T extends Item> Class<T> getToolClass() {
        return this.toolClass;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public static EnumTools byInstance(Item tool) {
        for (EnumTools type : EnumTools.values()) {
            if (!type.getToolClass().isInstance(tool)) continue;
            return type;
        }
        return null;
    }
}

