/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.gadget.shield;

import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.gadget.shield.ItemShieldBase;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCeruclaseShield
extends ItemShieldBase {
    private static final int RANGE = 5;

    public ItemCeruclaseShield() {
        super("ceruclase_shield", 500);
    }

    @Override
    public int func_77619_b() {
        return 18;
    }

    @Override
    public int func_77626_a(@Nonnull ItemStack stack) {
        return 200;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        EnumHand oppositeHand = handIn == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        EnumAction otherItemAction = playerIn.func_184586_b(oppositeHand).func_77975_n();
        if (!worldIn.field_72995_K && ItemCeruclaseShield.getIceShieldPos((Entity)playerIn, false) == null && otherItemAction != EnumAction.EAT && otherItemAction != EnumAction.DRINK) {
            BlockPos playerPos = playerIn.func_180425_c();
            playerIn.field_70143_R /= 2.0f;
            ItemCeruclaseShield.manageShield(worldIn, new BlockPos.MutableBlockPos(playerPos), false);
            String posString = "IceShieldPos:" + playerPos.func_177958_n() + "," + playerPos.func_177956_o() + "," + playerPos.func_177952_p();
            playerIn.func_184211_a(posString);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        ItemCeruclaseShield.removeTagAndShield(worldIn, (Entity)entityLiving);
    }

    public static void removeTagAndShield(World world, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = ItemCeruclaseShield.getIceShieldPos(entity, true);
        if (pos != null) {
            ItemCeruclaseShield.manageShield(world, new BlockPos.MutableBlockPos(pos), true);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_184811_cZ().func_185145_a((Item)ModItems.CERUCLASE_SHIELD, 140);
            }
        }
    }

    private static BlockPos getIceShieldPos(Entity entity, boolean remove) {
        String blockPosString = null;
        for (String str : entity.func_184216_O()) {
            if (!str.startsWith("IceShieldPos:")) continue;
            blockPosString = str;
            break;
        }
        if (blockPosString != null) {
            if (remove) {
                entity.func_184197_b(blockPosString);
            }
            String rightString = blockPosString.split(":")[1];
            String[] coord = rightString.split(",");
            return new BlockPos(Integer.parseInt(coord[0]), Integer.parseInt(coord[1]), Integer.parseInt(coord[2]));
        }
        return null;
    }

    private static void manageShield(World world, BlockPos.MutableBlockPos playerPos, boolean destroy) {
        if (!world.field_72995_K) {
            for (int x = -6; x < 6; ++x) {
                for (int y = -6; y < 6; ++y) {
                    for (int z = -6; z < 6; ++z) {
                        boolean canPlaceIce;
                        BlockPos blockPos = playerPos.func_177982_a(x, y, z);
                        IBlockState blockState = world.func_180495_p(blockPos);
                        if (Math.ceil(blockPos.func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p())) != 5.0) continue;
                        boolean bl = canPlaceIce = world.func_190527_a(ModBlocks.iceShield, blockPos, true, EnumFacing.UP, null) || blockState.func_177230_c() instanceof BlockBush;
                        if (!destroy) {
                            if (!canPlaceIce) continue;
                            world.func_175656_a(blockPos, ModBlocks.iceShield.func_176223_P());
                            continue;
                        }
                        if (blockState.func_177230_c() != ModBlocks.iceShield) continue;
                        Random random = new Random();
                        world.func_175684_a(blockPos, ModBlocks.iceShield, 10 + random.nextInt(11));
                    }
                }
            }
        }
        if (!destroy) {
            world.func_184133_a(null, (BlockPos)playerPos, SoundEvents.field_187567_bP, SoundCategory.BLOCKS, 1.0f, 2.0f);
        }
    }
}

