/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.gadget.gauntlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.config.GadgetsConfig;
import it.hurts.metallurgy_reforged.item.ItemExtra;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.util.EnumHand;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGauntlet
extends ItemExtra {
    public ItemGauntlet(String name) {
        super(name, MetallurgyTabs.tabSpecial, "gadget");
        this.func_77656_e(GadgetsConfig.Gauntlet.gauntletMaxDamage);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77942_o() && stack.func_77978_p().func_74767_n("hasEffect");
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        ArrayList list = Lists.newArrayList((Object[])Constants.GAUNTLET_ENCHANTMENTS);
        return list.contains(enchantment);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Gauntlet Damage modifier", GadgetsConfig.Gauntlet.gauntletAttackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Gauntlet Speed modifier", GadgetsConfig.Gauntlet.gauntletAttackSpeed, 0));
        }
        return multimap;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, @Nonnull ItemStack stack) {
        ItemStack mainHand = entityLiving.func_184614_ca();
        ItemStack offHand = entityLiving.func_184592_cb();
        if (offHand.func_77973_b().equals((Object)this) && mainHand.func_77973_b().equals((Object)this) && entityLiving.field_184622_au == EnumHand.MAIN_HAND) {
            if (!entityLiving.field_82175_bq || entityLiving.field_110158_av >= this.getArmSwingAnimationEnd(entityLiving) / 2 || entityLiving.field_110158_av < 0) {
                entityLiving.field_110158_av = -1;
                entityLiving.field_82175_bq = true;
                entityLiving.field_184622_au = EnumHand.OFF_HAND;
                if (entityLiving.field_70170_p instanceof WorldServer) {
                    ((WorldServer)entityLiving.field_70170_p).func_73039_n().func_151247_a((Entity)entityLiving, (Packet)new SPacketAnimation((Entity)entityLiving, 3));
                }
            }
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    private int getArmSwingAnimationEnd(EntityLivingBase entity) {
        if (entity.func_70644_a(MobEffects.field_76422_e)) {
            return 6 - (1 + entity.func_70660_b(MobEffects.field_76422_e).func_76458_c());
        }
        return entity.func_70644_a(MobEffects.field_76419_f) ? 6 + (1 + entity.func_70660_b(MobEffects.field_76419_f).func_76458_c()) * 2 : 6;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayerMP) {
            if (Item.field_77697_d.nextBoolean()) {
                stack.func_77972_a(1, attacker);
            } else {
                attacker.func_184592_cb().func_77972_a(1, attacker);
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }
}

