/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item.gadget;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import it.hurts.metallurgy_reforged.handler.GadgetsHandler;
import it.hurts.metallurgy_reforged.item.ItemExtra;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.sound.ModSounds;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOreDetector
extends ItemExtra {
    public static int indexColor;
    private boolean[] leds = new boolean[3];

    public ItemOreDetector() {
        super("ore_detector", MetallurgyTabs.tabSpecial, "gadget");
        this.func_77625_d(1);
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        List<Metal> metals = ItemOreDetector.getDetectorMetals(stack);
        for (int i = 0; i < metals.size(); ++i) {
            tooltip.add(TextFormatting.GRAY + "Metal " + i + ": " + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metals.get(i).toString()));
        }
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        return ItemOreDetector.getDetectorMetals(stack).size() * 25;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (ItemOreDetector.getDetectorMetals(stack).isEmpty()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (playerIn.func_184811_cZ().func_185143_a((Item)this, 0.0f) == 0.0f) {
            playerIn.func_184185_a(ModSounds.METAL_DETECTOR_PING, 1.0f, 1.0f);
            playerIn.func_184811_cZ().func_185145_a((Item)this, 100);
            if (this.getMaxDamage(stack) > 0) {
                if (stack.func_77952_i() >= this.getMaxDamage(stack)) {
                    ItemStack copy = new ItemStack((Item)this);
                    playerIn.func_184611_a(handIn, copy);
                } else {
                    stack.func_77972_a(1, (EntityLivingBase)playerIn);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        List<Metal> metals = ItemOreDetector.getDetectorMetals(stack);
        if (!metals.isEmpty()) {
            return this.getColorShiftFromMetals(metals);
        }
        return 0xFFFFFF;
    }

    private int getColorShiftFromMetals(List<Metal> metals) {
        float[][] metalColors = new float[metals.size()][3];
        for (int i = 0; i < metalColors.length; ++i) {
            metalColors[i] = metals.get(i).getStats().getColorRGBValues();
        }
        int indexFrom = indexColor % metals.size();
        int indexTo = indexFrom < metals.size() - 1 ? indexFrom + 1 : 0;
        double factor = GadgetsHandler.prevFactorToUse;
        int r = (int)(255.0 * ((double)metalColors[indexTo][0] * factor + (double)metalColors[indexFrom][0] * (1.0 - factor)));
        int g = (int)(255.0 * ((double)metalColors[indexTo][1] * factor + (double)metalColors[indexFrom][1] * (1.0 - factor)));
        int b = (int)(255.0 * ((double)metalColors[indexTo][2] * factor + (double)metalColors[indexFrom][2] * (1.0 - factor)));
        return MathHelper.func_180181_b((int)r, (int)g, (int)b);
    }

    @SideOnly(value=Side.CLIENT)
    public void setLEDs(boolean[] vals) {
        this.leds = vals;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLEDLit(int index) {
        return this.leds[index];
    }

    @SideOnly(value=Side.CLIENT)
    public void resetLEDs() {
        Arrays.fill(this.leds, false);
    }

    public static void addIngotsToDetector(ItemStack detector, List<ItemStack> ingots) {
        NBTTagCompound nbt = detector.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        for (int i = 0; i < ingots.size(); ++i) {
            Metal metal = ItemUtils.getMetalFromOreDictStack(ingots.get(i));
            String metalName = metal.toString();
            nbt.func_74778_a("metal_" + (i + 1), metalName);
        }
        detector.func_77982_d(nbt);
    }

    public static List<Metal> getDetectorMetals(ItemStack detector) {
        NBTTagCompound nbt = detector.func_77978_p();
        ArrayList metalSet = Lists.newArrayList();
        if (nbt != null && !nbt.func_82582_d()) {
            for (int i = 1; i <= 3; ++i) {
                String metalName = nbt.func_74779_i("metal_" + i);
                Metal metal = ModMetals.metalMap.get(metalName);
                if (metal == null) continue;
                metalSet.add(metal);
            }
        }
        return metalSet;
    }
}

