/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item;

import it.hurts.metallurgy_reforged.item.IMetalItem;
import it.hurts.metallurgy_reforged.item.ItemBase;
import it.hurts.metallurgy_reforged.item.ItemTypes;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.model.MetalSample;
import it.hurts.metallurgy_reforged.recipe.AlloyerRecipes;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemMetal
extends ItemBase
implements IMetalItem {
    private final ItemTypes type;
    private final MetalStats metal;

    public ItemMetal(MetalStats metal, ItemTypes type) {
        super(metal.getName() + "_" + type.getName(), type.getTab());
        this.type = type;
        this.metal = metal;
    }

    public ItemTypes getType() {
        return this.type;
    }

    @Override
    public MetalStats getMetalStats() {
        return this.metal;
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (this.type == ItemTypes.INGOT) {
            Pair<MetalSample, MetalSample> ingredients;
            int tier = this.metal.getOreHarvest() == -1 ? ((ingredients = AlloyerRecipes.getInstance().getIngredients(stack)) != null && ((MetalSample)ingredients.getLeft()).getMetal() != null && ((MetalSample)ingredients.getRight()).getMetal() != null ? Math.max(((MetalSample)ingredients.getLeft()).getMetal().getStats().getOreHarvest(), ((MetalSample)ingredients.getRight()).getMetal().getStats().getOreHarvest()) : 1) : this.metal.getOreHarvest();
            tooltip.add("Tier: " + ItemUtils.ScaleFormatting.values()[tier].format + tier);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

