/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.item;

import it.hurts.metallurgy_reforged.block.BlockOre;
import it.hurts.metallurgy_reforged.item.IMetalItem;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class ItemBlockOre
extends ItemBlock
implements IMetalItem {
    public ItemBlockOre(BlockOre block) {
        super((Block)block);
    }

    @Override
    @Nullable
    public MetalStats getMetalStats() {
        return ((BlockOre)this.field_150939_a).getMetalStats();
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemBlockOre.isLocked(stack);
    }

    public static boolean isLocked(ItemStack oreStack) {
        return oreStack.func_77978_p() != null && oreStack.func_77978_p().func_74767_n("locked");
    }

    public static void setLocked(ItemStack oreStack, boolean locked) {
        NBTTagCompound oreData = oreStack.func_77978_p();
        if (oreData == null) {
            oreData = new NBTTagCompound();
        }
        if (oreData.func_74767_n("locked") != locked) {
            oreData.func_74757_a("locked", locked);
        }
        oreStack.func_77982_d(oreData);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack oreStack = player.func_184586_b(hand);
        if (this.func_77636_d(oreStack)) {
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.getMetalStats() != null) {
            int tier = this.getMetalStats().getOreHarvest();
            assert (tier != -1);
            tooltip.add("Tier: " + ItemUtils.ScaleFormatting.values()[tier].format + tier);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

