/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic.material;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import it.hurts.metallurgy_reforged.integration.tic.material.MetallurgyTiCStats;
import it.hurts.metallurgy_reforged.integration.tic.material.TinkerMetals;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.material.ToolStats;
import it.hurts.metallurgy_reforged.util.Utils;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class TiCMaterials {
    private static final String TINKER_RENDER_INFO_PATH = "/assets/tconstruct/metallurgy_renders.json";
    static Map<Metal, MaterialRenderInfo.Metal> renderInfos = new HashMap<Metal, MaterialRenderInfo.Metal>();

    public static void addMaterialStats(Metal metal, Material material) {
        ToolStats TStats;
        MetalStats metalS = metal.getStats();
        MetallurgyTiCStats stats = TinkerMetals.getMetal(metal);
        if (stats != null) {
            for (AbstractMaterialStats stat : stats.stats) {
                TiCMaterials.registerStat(material, (IMaterialStats)stat);
            }
        } else if (metalS != null && (TStats = metalS.getToolStats()) != null) {
            TiCMaterials.registerStats(material, new IMaterialStats[]{MetallurgyTiCStats.getHeadA(metal), MetallurgyTiCStats.getHandleA(metal), MetallurgyTiCStats.getExtraA(metal), MetallurgyTiCStats.getBowA(metal)});
        }
    }

    public static void registerStat(Material material, IMaterialStats stats) {
        if (!material.hasStats(stats.getIdentifier())) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)stats);
        }
    }

    public static void registerStats(Material material, IMaterialStats ... stats) {
        for (IMaterialStats stat : stats) {
            TiCMaterials.registerStat(material, stat);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initializeRenderInfos() {
        try {
            Gson gson = new GsonBuilder().create();
            JsonObject renderObj = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)Files.newBufferedReader(Utils.getPath(TINKER_RENDER_INFO_PATH)), JsonObject.class);
            ModMetals.metalMap.forEach((name, metal) -> {
                if (metal.hasToolSet()) {
                    JsonObject parametersObj = JsonUtils.func_152754_s((JsonObject)renderObj, (String)metal.toString());
                    float shinyness = JsonUtils.func_151217_k((JsonObject)parametersObj, (String)"shinyness");
                    float brightness = JsonUtils.func_151217_k((JsonObject)parametersObj, (String)"brightness");
                    float hueshift = JsonUtils.func_151217_k((JsonObject)parametersObj, (String)"hueshift");
                    MaterialRenderInfo.Metal info = new MaterialRenderInfo.Metal(metal.getStats().getColorHex(), shinyness, brightness, hueshift);
                    renderInfos.put((Metal)metal, info);
                }
            });
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }
}

