/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic.material;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.integration.tic.material.TiCMaterials;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.util.Utils;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.Material;

public class TiCMaterial
extends Material {
    private final Metal metal;

    public TiCMaterial(Metal metal) {
        super(metal.toString(), metal.getMolten().getColor(), false);
        this.metal = metal;
        this.setFluid(metal.getMolten());
        this.setCastable(true);
        this.addCommonItems(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString()));
        this.setRepresentativeItem("ingot" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString()));
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT) {
            this.setRenderInfo((MaterialRenderInfo)TiCMaterials.renderInfos.get(metal));
        }
        TiCMaterials.addMaterialStats(metal, this);
    }

    public String getLocalizedName() {
        return Utils.localizeIgnoreFormat("material.metallurgy." + this.metal.toString() + ".name");
    }
}

