/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic;

import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.integration.tic.MetallurgyTinkerTraits;
import it.hurts.metallurgy_reforged.material.Metal;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class SetTinkerTraits {
    public static void addTraits(Metal metal, Material material) {
        switch (metal.getStats().getName()) {
            case "midasium": {
                SetTinkerTraits.addToEveryPart(material, TinkerTraits.writable2);
                if (!GeneralConfig.enableDuplicationTrait) break;
                SetTinkerTraits.addToEveryPart(material, MetallurgyTinkerTraits.duplicaitonTrait);
                break;
            }
            case "ignatius": {
                material.addTrait((ITrait)MetallurgyTinkerTraits.vulcanTrait, "head");
                break;
            }
            case "vulcanite": {
                material.addTrait((ITrait)MetallurgyTinkerTraits.vulcanTrait1, "head");
                material.addTrait((ITrait)TinkerTraits.superheat, "handle");
                break;
            }
            case "eximite": {
                material.addTrait((ITrait)TinkerTraits.enderference, "head");
                break;
            }
            case "vyroxeres": {
                SetTinkerTraits.addToEveryPart(material, TinkerTraits.poisonous);
                break;
            }
            case "mithril": {
                break;
            }
            case "damascus_steel": {
                material.addTrait((ITrait)TinkerTraits.dense, "head");
                SetTinkerTraits.addToEveryPart(material, TinkerTraits.duritos);
                break;
            }
            case "shadow_iron": {
                SetTinkerTraits.addToEveryPart(material, MetallurgyTinkerTraits.obscureTrait);
                break;
            }
            case "sanguinite": {
                material.addTrait((ITrait)MetallurgyTinkerTraits.lifeStealTrait, "head");
                material.addTrait((ITrait)MetallurgyTinkerTraits.lifeStealTrait, "handle");
                break;
            }
            case "tartarite": {
                material.addTrait((ITrait)MetallurgyTinkerTraits.witherTrait, "head");
                break;
            }
            case "alduorite": {
                material.addTrait((ITrait)TinkerTraits.unnatural, "extra");
                material.addTrait((ITrait)TinkerTraits.unnatural, "head");
                break;
            }
            case "desichalkos": {
                material.addTrait((ITrait)MetallurgyTinkerTraits.kingDiceTrait, "extra");
                break;
            }
            case "deep_iron": {
                SetTinkerTraits.addToEveryPart(material, MetallurgyTinkerTraits.opistognathusTrait);
                break;
            }
        }
    }

    private static void addToEveryPart(Material material, AbstractTrait trait) {
        material.addTrait((ITrait)trait, "head");
        material.addTrait((ITrait)trait, "handle");
        material.addTrait((ITrait)trait, "extra");
    }
}

