/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.tic;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.config.GadgetsConfig;
import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.fluid.ModFluids;
import it.hurts.metallurgy_reforged.integration.tic.MetallurgyTinkerFuels;
import it.hurts.metallurgy_reforged.integration.tic.SetTinkerTraits;
import it.hurts.metallurgy_reforged.integration.tic.material.TiCMaterial;
import it.hurts.metallurgy_reforged.item.ItemMetal;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.model.MetalSample;
import it.hurts.metallurgy_reforged.recipe.AlloyerRecipes;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.BucketCastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.ranged.item.CrossBow;

public class IntegrationTIC {
    public static List<?> blacklistedMaterials = Arrays.asList(GeneralConfig.tinkerMaterialsBlacklist);
    private static final Set<Metal> vanillaTicMetals = Sets.newHashSet((Object[])new Metal[]{ModMetals.COPPER, ModMetals.BRONZE, ModMetals.ZINC, ModMetals.TIN, ModMetals.SILVER, ModMetals.STEEL, ModMetals.ELECTRUM});

    public static void preInit() {
        ModMetals.metalMap.forEach((name, metal) -> {
            if (IntegrationTIC.checkMaterial(metal) && IntegrationTIC.checkMaterialPreInit(name) && !blacklistedMaterials.contains(name)) {
                TiCMaterial material = new TiCMaterial((Metal)metal);
                TinkerRegistry.addMaterial((Material)material);
            }
        });
    }

    public static void init() {
        ModMetals.metalMap.forEach((name, metal) -> {
            if (IntegrationTIC.checkMaterial(metal) && !blacklistedMaterials.contains(name)) {
                Material m = TinkerRegistry.getMaterial((String)metal.getStats().getName());
                SetTinkerTraits.addTraits(metal, m);
                if (m.getFluid() == null) {
                    m.setFluid((Fluid)metal.getMolten());
                }
                TinkerSmeltery.registerOredictMeltingCasting((Fluid)m.getFluid(), (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name));
                TinkerSmeltery.registerToolpartMeltingCasting((Material)m);
            }
        });
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)ModItems.THERMITE_DUST, (int)1000), (Fluid)ModFluids.THERMITE, GadgetsConfig.ThermiteDust.temperature));
        TinkerRegistry.registerTableCasting((ICastingRecipe)new BucketCastingRecipe(Items.field_151133_ar));
    }

    public static void postInit() {
        for (Table.Cell entry : AlloyerRecipes.getInstance().getRecipeTable().cellSet()) {
            FluidStack output = IntegrationTIC.getFluidFromIngot(((MetalSample)entry.getValue()).getStack());
            FluidStack input1 = IntegrationTIC.getFluidFromIngot(((MetalSample)entry.getRowKey()).getStack());
            FluidStack input2 = IntegrationTIC.getFluidFromIngot(((MetalSample)entry.getColumnKey()).getStack());
            if (output == null || input1 == null || input2 == null || output.getFluid() == TinkerFluids.bronze || output.getFluid() == TinkerFluids.electrum) continue;
            TinkerRegistry.registerAlloy((FluidStack)output, (FluidStack[])new FluidStack[]{input1, input2});
        }
        Metallurgy.logger.info("Tinker Smeltery Recipes for Metallurgy Loaded");
        MetallurgyTinkerFuels.init();
    }

    public static FluidStack getFluidFromIngot(ItemStack stack) {
        Metal metal;
        Fluid fluid;
        MeltingRecipe recipe = TinkerRegistry.getMelting((ItemStack)stack);
        Item item = stack.func_77973_b();
        Fluid fluid2 = fluid = recipe != null ? recipe.getResult().getFluid() : null;
        if (Items.field_151042_j.equals(item)) {
            fluid = TinkerFluids.iron;
        } else if (Items.field_151043_k.equals(item)) {
            fluid = TinkerFluids.gold;
        } else if (stack.func_77973_b() instanceof ItemMetal && vanillaTicMetals.contains(metal = ItemUtils.getMetalFromItem(stack.func_77973_b()))) {
            try {
                fluid = (Fluid)TinkerFluids.class.getDeclaredField(metal.toString()).get(TinkerFluids.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        int c = stack.func_190916_E();
        return fluid != null ? new FluidStack(fluid, (c <= 0 ? 1 : c) * 144) : null;
    }

    public static boolean checkMaterial(Metal metal) {
        return !vanillaTicMetals.contains(metal);
    }

    public static boolean checkMaterialPreInit(String material) {
        return TinkerRegistry.getMaterial((String)material).equals(Material.UNKNOWN);
    }

    public static boolean isCrossbow(Item item) {
        return item instanceof CrossBow;
    }

    static {
        vanillaTicMetals.removeIf(Objects::isNull);
    }
}

