/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.silentgems;

import it.hurts.metallurgy_reforged.integration.silentgems.MetallurgyPartProperties;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.item.tool.ItemGemBow;

public class MetallurgyToolPart
extends ToolPartMain {
    private final MetallurgyPartProperties properties;

    public MetallurgyToolPart(MetallurgyPartProperties properties) {
        super("metallurgy:" + properties.getMetalStats().getName() + "_ingot", properties.getCraftingStack());
        this.tier = properties.getTier();
        this.properties = properties;
    }

    public ModelResourceLocation getModel(ItemStack tool, ToolPartPosition pos, int frame) {
        Item item = tool.func_77973_b();
        String name = item.getRegistryName().func_110623_a();
        name = "silentgems:" + name.toLowerCase() + "/" + name;
        boolean isBow = item instanceof ItemGemBow;
        String num = isBow ? "" : "15";
        String frameNum = isBow && frame == 3 ? "_3" : "";
        switch (pos) {
            case HEAD: {
                name = name + num + frameNum;
                break;
            }
            case ROD_DECO: {
                name = name + "_deco";
                break;
            }
            default: {
                return null;
            }
        }
        return new ModelResourceLocation(name.toLowerCase(), "inventory");
    }

    @Nonnull
    public String getCraftingOreDictName() {
        return this.properties.getCraftingOreName();
    }

    public int getDurability() {
        return this.properties.getDurability();
    }

    public float getHarvestSpeed() {
        return this.properties.getMiningSpeed();
    }

    public int getHarvestLevel() {
        return this.properties.getHarvestLevel();
    }

    public float getMeleeDamage() {
        return this.properties.getMeleeDamage();
    }

    public float getMagicDamage() {
        return 0.0f;
    }

    public int getEnchantability() {
        return this.properties.getEnchantability();
    }

    public float getMeleeSpeed() {
        return this.properties.getMeleeSpeed();
    }

    public float getChargeSpeed() {
        return this.properties.getChargeSpeed();
    }

    public float getProtection() {
        return this.properties.getProtection();
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getColor(ItemStack toolOrArmor, IPartPosition position, int animationFrame) {
        return this.properties.getColor();
    }

    public String getDisplayNamePrefix(ItemStack partRep) {
        return this.properties.getNamePrefix();
    }

    public String getDisplayName(ItemStack partRep) {
        if (partRep.func_82837_s()) {
            return partRep.func_82833_r();
        }
        return this.properties.getName();
    }
}

